/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class Catalog
implements ActionListener,
MouseListener,
KeyListener {
    private static final String PRG = "Catalog";
    private static final String AUTHOR = "T.Berndt";
    private static final String VERSION = "0.7";
    private static String[] labels = new String[]{"eBook-Catalog", "Authors", "Titles", "Book", "Author", "Title", "Genre", "Series", "File", "Image", "Description", "New", "Add", "Save", "Delete", "eBook", "Edit", "Cancel", "Open"};
    private static String[] dialogStr = new String[]{"Catalog-Error", "An error occurred loading the booklist.", "No filename given.", "No desitination path given.", "Cannot create destination directory.", "The given file does not exist.", "Cannot copy the book.", "Cannot copy the image.", "Cannot write Manifest file", "Select file", "Select image", "Path to the eBook:", "Catalog-Dialog", "A runtime error occurred."};
    private static final Catalog instance = new Catalog();
    Books books = Books.getInstance();
    Book book;
    Book backup;
    JFrame window;
    JList authorList;
    JList titleList;
    DefaultListModel authorModel;
    DefaultListModel titleModel;
    JTextField authorText;
    JTextField titleText;
    JComboBox genreCB;
    DefaultComboBoxModel genreModel;
    JTextField seriesText;
    JButton fileBT;
    JTextField fileText;
    JButton imageBT;
    JTextField imageText;
    JLabel imageLabel;
    JEditorPane descriptionText;
    JButton newBT;
    JButton addBT;
    JButton saveBT;
    JButton deleteBT;
    JButton eBookBT;
    JButton openBT;
    JToggleButton editBT;
    JButton cancelBT;
    FileChooser fc;
    String eBookPath;
    String propFile;
    boolean canOpen;
    Locale locale;

    public static void main(String[] stringArray) {
        Catalog catalog = Catalog.getInstance();
        catalog.init(stringArray);
    }

    public static Catalog getInstance() {
        return instance;
    }

    public Book getBook() {
        return this.book;
    }

    public void init(String[] stringArray) {
        this.loadPrefs(stringArray);
        this.initUI();
        this.loadBooks();
        this.window.validate();
        this.window.pack();
        this.window.setVisible(true);
    }

    public void loadPrefs(String[] stringArray) {
        String string = null;
        boolean bl = false;
        this.propFile = System.getProperties().getProperty("user.home") + File.separator + "." + PRG + ".rc";
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(this.propFile)));
            string = properties.getProperty("lang");
            this.eBookPath = properties.getProperty("path");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-lang") && i + 1 < stringArray.length) {
                string = stringArray[i + 1];
            }
            if (!stringArray[i].equals("-path") || i + 1 >= stringArray.length) continue;
            this.eBookPath = stringArray[i + 1];
        }
        this.initLocale(string);
    }

    void savePrefs() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.propFile));
            String string = this.locale.getCountry();
            if (string.length() > 0) {
                printWriter.println("lang: " + string);
            }
            printWriter.println("path: " + this.eBookPath);
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void initLocale(String string) {
        Object object;
        this.locale = string == null ? Locale.getDefault() : (((String[])(object = string.replaceFirst("[.].*", "").split("_", 2))).length == 2 ? new Locale((String)object[0], (String)object[1]) : new Locale(string));
        try {
            object = ResourceBundle.getBundle("catalogMsgs", this.locale);
            Catalog.labels[0] = ((ResourceBundle)object).getString("label_window_title");
            Catalog.labels[1] = ((ResourceBundle)object).getString("label_authors");
            Catalog.labels[2] = ((ResourceBundle)object).getString("label_titles");
            Catalog.labels[3] = ((ResourceBundle)object).getString("label_book");
            Catalog.labels[4] = ((ResourceBundle)object).getString("label_author");
            Catalog.labels[5] = ((ResourceBundle)object).getString("label_title");
            Catalog.labels[6] = ((ResourceBundle)object).getString("label_genre");
            Catalog.labels[7] = ((ResourceBundle)object).getString("label_series");
            Catalog.labels[8] = ((ResourceBundle)object).getString("label_file");
            Catalog.labels[9] = ((ResourceBundle)object).getString("label_image");
            Catalog.labels[10] = ((ResourceBundle)object).getString("label_desc");
            Catalog.labels[11] = ((ResourceBundle)object).getString("label_new");
            Catalog.labels[12] = ((ResourceBundle)object).getString("label_add");
            Catalog.labels[13] = ((ResourceBundle)object).getString("label_save");
            Catalog.labels[14] = ((ResourceBundle)object).getString("label_delete");
            Catalog.labels[15] = ((ResourceBundle)object).getString("label_ebook");
            Catalog.labels[16] = ((ResourceBundle)object).getString("label_edit");
            Catalog.labels[17] = ((ResourceBundle)object).getString("label_cancel");
            Catalog.labels[18] = ((ResourceBundle)object).getString("label_open");
            Catalog.dialogStr[0] = ((ResourceBundle)object).getString("dialog_err");
            Catalog.dialogStr[1] = ((ResourceBundle)object).getString("dialog_load_err");
            Catalog.dialogStr[2] = ((ResourceBundle)object).getString("dialog_no_file");
            Catalog.dialogStr[3] = ((ResourceBundle)object).getString("dialog_no_path");
            Catalog.dialogStr[4] = ((ResourceBundle)object).getString("dialog_dir_err");
            Catalog.dialogStr[5] = ((ResourceBundle)object).getString("dialog_file_nex");
            Catalog.dialogStr[6] = ((ResourceBundle)object).getString("dialog_cant_copy_book");
            Catalog.dialogStr[7] = ((ResourceBundle)object).getString("dialog_cant_copy_image");
            Catalog.dialogStr[8] = ((ResourceBundle)object).getString("dialog_cant_write_manif");
            Catalog.dialogStr[9] = ((ResourceBundle)object).getString("dialog_select_file");
            Catalog.dialogStr[10] = ((ResourceBundle)object).getString("dialog_select_image");
            Catalog.dialogStr[11] = ((ResourceBundle)object).getString("dialog_device_path");
            Catalog.dialogStr[12] = ((ResourceBundle)object).getString("dialog_dialog");
            Catalog.dialogStr[13] = ((ResourceBundle)object).getString("dialog_runtime_err");
            this.savePrefs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Warning: Resource file not found; using default (EN)");
        }
    }

    void initUI() {
        String string = System.getProperty("os.name").toLowerCase();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (string.indexOf("mac") != -1) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.canOpen = true;
            this.fc = new AWTFileChooser();
        } else {
            this.fc = new SwingFileChooser();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.authorModel = new DefaultListModel();
        this.authorList = new JList(this.authorModel);
        this.authorList.addMouseListener(this);
        this.authorList.addKeyListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.authorList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(labels[1]));
        jPanel.add(jScrollPane);
        jPanel.setPreferredSize(new Dimension(250, 120));
        this.titleModel = new DefaultListModel();
        this.titleList = new JList(this.titleModel);
        this.titleList.addMouseListener(this);
        this.titleList.addKeyListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.titleList);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(labels[2]));
        jPanel2.add(jScrollPane2);
        jPanel2.setPreferredSize(new Dimension(250, 120));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(labels[3]));
        this.authorText = UIFactory.newTextField(20, "", Book.keys[1], this, this);
        this.authorText.setEnabled(false);
        jPanel3.add(UIFactory.addElements(labels[4], this.authorText));
        this.titleText = UIFactory.newTextField(20, "", Book.keys[2], this, this);
        this.titleText.setEnabled(false);
        jPanel3.add(UIFactory.addElements(labels[5], this.titleText));
        this.genreModel = new DefaultComboBoxModel();
        this.genreCB = UIFactory.newComboBox(this.genreModel, Book.keys[3], null);
        this.genreCB.setEnabled(false);
        this.genreCB.setEditable(true);
        jPanel3.add(UIFactory.addElements(labels[6], this.genreCB));
        this.seriesText = UIFactory.newTextField(20, "", Book.keys[4], this, this);
        this.seriesText.setEnabled(false);
        jPanel3.add(UIFactory.addElements(labels[7], this.seriesText));
        this.fileBT = UIFactory.newButton(labels[8], "BT:" + labels[8], 'F', this);
        this.fileBT.setEnabled(false);
        this.fileText = UIFactory.newTextField(20, "", Book.keys[5], this, this);
        this.fileText.setEnabled(false);
        UIFactory.addElements(jPanel3, (JComponent)this.fileBT, this.fileText);
        this.imageBT = UIFactory.newButton(labels[9], "BT:" + labels[9], 'I', this);
        this.imageBT.setEnabled(false);
        this.imageText = UIFactory.newTextField(20, "", Book.keys[6], this, this);
        this.imageText.setEnabled(false);
        UIFactory.addElements(jPanel3, (JComponent)this.imageBT, this.imageText);
        JPanel jPanel4 = new JPanel(new FlowLayout(4));
        this.imageLabel = new JLabel();
        jPanel4.setPreferredSize(new Dimension(200, 200));
        jPanel4.add(this.imageLabel);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.descriptionText = new JEditorPane();
        this.descriptionText.addKeyListener(this);
        this.descriptionText.setPreferredSize(new Dimension(400, 120));
        this.descriptionText.setEnabled(false);
        jPanel5.setBorder(BorderFactory.createTitledBorder(labels[10]));
        jPanel5.add((Component)new JScrollPane(this.descriptionText), "Center");
        jPanel3.add(jPanel5);
        jPanel3.setBorder(BorderFactory.createTitledBorder(labels[3]));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        JPanel jPanel7 = new JPanel(new FlowLayout());
        this.newBT = UIFactory.newButton(labels[11], "BT:" + labels[11], 'N', this);
        this.addBT = UIFactory.newButton(labels[12], "BT:" + labels[12], 'A', this);
        this.saveBT = UIFactory.newButton(labels[13], "BT:" + labels[13], 'S', this);
        this.deleteBT = UIFactory.newButton(labels[14], "BT:" + labels[14], 'D', this);
        this.eBookBT = UIFactory.newButton(labels[15], "BT:" + labels[15], 'B', this);
        this.editBT = new JToggleButton(labels[16]);
        this.editBT.setActionCommand("BT:" + labels[16]);
        this.editBT.setMnemonic('E');
        this.editBT.addActionListener(this);
        this.cancelBT = UIFactory.newButton(labels[17], "BT:" + labels[17], 'C', this);
        this.openBT = UIFactory.newButton(labels[18], "BT:" + labels[18], 'O', this);
        this.openBT.setVisible(this.canOpen);
        jPanel7.add(this.newBT);
        jPanel7.add(this.editBT);
        jPanel7.add(this.addBT);
        jPanel7.add(this.cancelBT);
        jPanel7.add(this.saveBT);
        jPanel7.add(this.deleteBT);
        jPanel7.add(this.eBookBT);
        jPanel7.add(this.openBT);
        this.addBT.setVisible(false);
        this.cancelBT.setVisible(false);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel6, "Center");
        jPanel8.add((Component)jPanel7, "South");
        this.window = new JFrame(labels[0]);
        this.window.setDefaultCloseOperation(2);
        this.window.setContentPane(jPanel8);
    }

    void makeAuthorList() {
        int n;
        int n2 = 0;
        int n3 = this.books.size();
        Object[] objectArray = new String[n3 + 1];
        objectArray[n3] = "*";
        for (n = 0; n < n3; ++n) {
            objectArray[n2++] = this.books.get(n).getAuthor();
        }
        Arrays.sort(objectArray);
        this.authorModel.removeAllElements();
        for (n = 0; n <= n2; ++n) {
            if (this.authorModel.contains(objectArray[n])) continue;
            this.authorModel.addElement(objectArray[n]);
        }
        this.authorList.setSelectedIndex(0);
    }

    void makeTitleList(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = this.books.size();
        Object[] objectArray = new Title[n4];
        if (string == null) {
            string = this.book.getAuthor();
        }
        if (n4 == 0) {
            return;
        }
        if (string2 == null && this.titleList.getSelectedIndex() != -1) {
            string2 = ((Title)this.titleList.getSelectedValue()).guid;
        }
        this.titleModel.removeAllElements();
        for (n = 0; n < n4; ++n) {
            Book book = this.books.get(n);
            if (!string.equals("*") && !string.equals(book.getAuthor())) continue;
            objectArray[n2++] = new Title(book.getGUID(), book.getTitle(), book.getSeries(), n);
        }
        Arrays.sort(objectArray, 0, n2);
        for (n = 0; n < n2; ++n) {
            this.titleModel.addElement(objectArray[n]);
            if (((Title)objectArray[n]).guid != string2) continue;
            n3 = n;
        }
        if (objectArray.length > 0) {
            this.titleList.setSelectedIndex(n3 != -1 ? n3 : 0);
            this.titleList.ensureIndexIsVisible(n3);
            this.titleList.grabFocus();
            this.setBook();
        }
        this.window.setTitle(labels[0] + " (" + labels[1] + ": " + this.authorModel.size() + ", " + labels[2] + ": " + this.titleModel.getSize() + "/" + this.books.size() + ")");
    }

    void makeTitleList(String string) {
        this.makeTitleList(string, null);
    }

    void loadBooks() {
        if (!this.books.load()) {
            this.errorMsg(dialogStr[1]);
            return;
        }
        if (this.books.size() > 0) {
            this.makeAuthorList();
            this.makeTitleList("*");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.books.size(); ++i) {
                String string = this.books.get(i).getGenre();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            Object[] objectArray = arrayList.toArray();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.genreModel.addElement(objectArray[i]);
            }
        } else {
            this.newBook();
        }
    }

    void saveBooks() {
        this.books.save();
    }

    void setBook() {
        int n = this.titleList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Title title = (Title)this.titleList.getSelectedValue();
        this.book = this.books.get(title.pos);
        this.authorText.setText(this.book.getAuthor());
        this.titleText.setText(this.book.getTitle());
        this.genreCB.setSelectedItem(this.book.getGenre());
        this.seriesText.setText(this.book.getSeries());
        this.fileText.setText(this.book.getFileName());
        this.imageText.setText(this.book.getImageName());
        this.descriptionText.setText(this.book.getDescription());
        this.setImage();
    }

    void setImage() {
        String string = this.book.getImageName();
        if (string != null && string.length() > 0) {
            ImageIcon imageIcon = new ImageIcon(string);
            Image image = imageIcon.getImage();
            imageIcon.setImage(image.getScaledInstance(150, 150, 4));
            this.imageLabel.setIcon(imageIcon);
        } else {
            this.imageLabel.setIcon(null);
        }
    }

    void clearBook() {
        this.authorText.setText("");
        this.titleText.setText("");
        this.genreCB.setSelectedIndex(-1);
        this.seriesText.setText("");
        this.fileText.setText("");
        this.imageText.setText("");
        this.descriptionText.setText("");
        if (this.book != null) {
            this.book.setImageName("");
            this.setImage();
        }
    }

    void newBook() {
        String string = (String)this.authorList.getSelectedValue();
        this.clearBook();
        this.backup = this.book;
        this.book = new Book();
        this.book.createGUID();
        this.books.add(this.book);
        this.setEditable(true);
        this.editBT.setVisible(false);
        this.addBT.setVisible(true);
        if (this.books.size() <= 1) {
            this.buttonsOff();
        }
        if (string != null && !string.equals("*")) {
            this.authorText.setText(string);
            this.book.setAuthor(string);
        }
        this.authorText.grabFocus();
    }

    void addBook() {
        if (this.book.getAuthor().length() == 0 && this.book.getTitle().length() == 0) {
            if (this.titleModel.size() <= 0) {
                this.authorText.grabFocus();
                return;
            }
            this.cancelEdit();
            return;
        }
        String string = this.book.getAuthor();
        if (!this.authorModel.contains(string)) {
            this.makeAuthorList();
        }
        this.authorList.setSelectedValue(string, true);
        this.setEditable(false);
        this.editBT.setVisible(true);
    }

    void deleteBook() {
        int n = this.titleList.getSelectedIndex();
        int n2 = this.titleModel.size() - 1;
        Title title = (Title)this.titleList.getSelectedValue();
        this.books.remove(title.pos);
        if (this.books.size() <= 0) {
            this.authorModel.clear();
            this.titleModel.clear();
            this.clearBook();
            this.buttonsOff();
            return;
        }
        this.makeTitleList((String)this.authorList.getSelectedValue());
        if (n2 > 0) {
            if (n >= n2) {
                --n;
            }
            this.titleList.setSelectedIndex(n);
        } else {
            this.makeAuthorList();
            this.makeTitleList("*");
        }
    }

    void cancelEdit() {
        if (this.addBT.isVisible()) {
            this.books.remove(this.books.size() - 1);
            this.setBook();
            this.editBT.setVisible(true);
        } else {
            if (this.titleList.getSelectedIndex() < 0) {
                return;
            }
            this.books.set(((Title)this.titleList.getSelectedValue()).pos, this.backup);
            this.editBT.setSelected(false);
        }
        this.setEditable(false);
    }

    void setEditable(boolean bl) {
        if (bl) {
            this.authorText.setEnabled(true);
            this.titleText.setEnabled(true);
            this.genreCB.setEnabled(true);
            this.seriesText.setEnabled(true);
            this.fileBT.setEnabled(true);
            this.fileText.setEnabled(true);
            this.imageBT.setEnabled(true);
            this.imageText.setEnabled(true);
            this.descriptionText.setEnabled(true);
            this.newBT.setVisible(false);
            this.deleteBT.setVisible(false);
            this.eBookBT.setVisible(false);
            this.cancelBT.setVisible(true);
            this.saveBT.setVisible(false);
            this.openBT.setVisible(false);
            this.authorList.setEnabled(false);
            this.titleList.setEnabled(false);
            this.genreCB.addActionListener(this);
            this.authorText.grabFocus();
        } else {
            this.authorText.setEnabled(false);
            this.titleText.setEnabled(false);
            this.genreCB.setEnabled(false);
            this.seriesText.setEnabled(false);
            this.fileBT.setEnabled(false);
            this.fileText.setEnabled(false);
            this.imageBT.setEnabled(false);
            this.imageText.setEnabled(false);
            this.descriptionText.setEnabled(false);
            this.addBT.setVisible(false);
            this.newBT.setVisible(true);
            this.deleteBT.setVisible(true);
            this.eBookBT.setVisible(true);
            this.cancelBT.setVisible(false);
            this.saveBT.setVisible(true);
            this.openBT.setVisible(true);
            this.authorList.setEnabled(true);
            this.titleList.setEnabled(true);
            this.genreCB.removeActionListener(this);
            String string = (String)this.authorList.getSelectedValue();
            if (!string.equals(this.book.getAuthor())) {
                this.makeAuthorList();
                this.authorList.setSelectedValue(this.book.getAuthor(), true);
            }
            this.makeTitleList(this.book.getAuthor(), this.book.getGUID());
        }
    }

    void buttonsOff() {
        this.editBT.setVisible(false);
        this.deleteBT.setVisible(false);
        this.eBookBT.setVisible(false);
        this.cancelBT.setVisible(false);
        this.saveBT.setVisible(false);
    }

    void sendBook() {
        File file;
        if (this.book == null) {
            return;
        }
        String string = (String)JOptionPane.showInputDialog(this.window, dialogStr[11], dialogStr[12], -1, null, null, this.eBookPath);
        if (string == null) {
            return;
        }
        if (!string.equals(this.eBookPath)) {
            this.eBookPath = string;
            this.savePrefs();
        }
        String string2 = this.book.getFileName();
        String string3 = this.book.getImageName();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (string2.length() == 0) {
            this.errorMsg(dialogStr[2]);
            return;
        }
        if (this.eBookPath.length() == 0) {
            this.errorMsg(dialogStr[3]);
            return;
        }
        if (!this.eBookPath.endsWith(File.separator)) {
            this.eBookPath = this.eBookPath + File.separator;
        }
        if (!(file = new File(string4 = this.eBookPath + this.book.getTitle() + File.separator)).exists() && !file.mkdir()) {
            this.errorMsg(dialogStr[4] + " '" + string4 + "'");
            return;
        }
        file = new File(string2);
        if (!file.exists()) {
            this.errorMsg(dialogStr[5]);
            return;
        }
        string5 = file.getName();
        if (!this.copy(string2, string4 + string5)) {
            this.errorMsg(dialogStr[6]);
            return;
        }
        if (string3 != null && string3.length() > 0) {
            file = new File(this.book.getImageName());
            if (file.exists()) {
                string6 = file.getName();
                if (!this.copy(string3, string4 + string6)) {
                    this.errorMsg(dialogStr[7]);
                    return;
                }
            } else {
                string6 = "";
            }
        }
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateInstance(1, Locale.getDefault());
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string4 + "manifest.xml"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--manifest generated by Catalog V0.7-->\n<package>\n  <metadata>\n    <dc-metadata>\n      <Title>" + this.book.getTitle() + "</Title>\n" + "      <Description>" + this.book.getAuthor() + (this.book.getSeries().length() > 0 ? " - " + this.book.getSeries() : "") + "</Description>\n" + "      <Date>" + dateFormat.format(date) + "</Date>\n" + "    </dc-metadata>\n" + "    <y-metadata>\n" + "      <startpage>" + string5 + "</startpage>\n" + "      <image>" + string6 + "</image>\n" + "      <version>000</version>\n" + "    </y-metadata>\n" + "  </metadata>\n" + "</package>");
            printWriter.close();
        }
        catch (IOException iOException) {
            this.errorMsg(dialogStr[8]);
        }
    }

    boolean copy(String string, String string2) {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
            while ((n = bufferedReader.read()) != -1) {
                bufferedWriter.write(n);
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    void openBook() {
        String string = this.book.getFileName();
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = "/tmp/catalogFile";
        this.copy(string, string2);
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] stringArray = new String[]{"open", "-a", "/Applications/Preview.app/Contents/MacOS/Preview", string2};
            Process process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (bufferedReader.ready()) {
                StringBuffer stringBuffer = new StringBuffer();
                while (bufferedReader.ready()) {
                    stringBuffer.append(bufferedReader.readLine());
                }
                System.out.println("STDERR\n" + stringBuffer);
            }
        }
        catch (Exception exception) {
            this.errorMsg(dialogStr[13]);
        }
    }

    void errorMsg(String string) {
        JOptionPane.showMessageDialog(this.window, string, dialogStr[0], 0);
    }

    void addGenre(String string) {
        this.genreModel.addElement(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.genreModel.getSize(); ++i) {
            arrayList.add((String)this.genreModel.getElementAt(i));
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        this.genreModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            this.genreModel.addElement(objectArray[i]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals(Book.keys[1])) {
            this.titleText.grabFocus();
        } else if (string.equals(Book.keys[2])) {
            this.genreCB.grabFocus();
        } else if (string.equals(Book.keys[3])) {
            String string2 = (String)this.genreCB.getSelectedItem();
            if (this.genreCB.getSelectedIndex() == -1) {
                this.addGenre(string2);
                this.genreModel.setSelectedItem(string2);
            }
            this.book.setGenre(string2);
            this.seriesText.grabFocus();
        } else if (string.equals(Book.keys[4])) {
            this.fileText.grabFocus();
        } else if (string.equals(Book.keys[5])) {
            this.imageText.grabFocus();
        } else if (string.equals(Book.keys[6])) {
            this.descriptionText.grabFocus();
        } else if (string.equals("BT:" + labels[8])) {
            if (this.fc.getFileName(this.window, this.fileText, dialogStr[9])) {
                this.book.setFileName(this.fileText.getText());
            }
        } else if (string.equals("BT:" + labels[9])) {
            if (this.fc.getFileName(this.window, this.imageText, dialogStr[10])) {
                this.book.setImageName(this.imageText.getText());
                this.setImage();
            }
        } else if (string.equals("BT:" + labels[11])) {
            this.newBook();
        } else if (string.equals("BT:" + labels[12])) {
            this.addBook();
        } else if (string.equals("BT:" + labels[13])) {
            this.saveBooks();
        } else if (string.equals("BT:" + labels[14])) {
            this.deleteBook();
        } else if (string.equals("BT:" + labels[15])) {
            this.sendBook();
        } else if (string.equals("BT:" + labels[16])) {
            this.backup = this.book.clone();
            this.setEditable(this.editBT.isSelected());
        } else if (string.equals("BT:" + labels[17])) {
            this.cancelEdit();
        } else if (string.equals("BT:" + labels[18])) {
            this.openBook();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 1) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object == this.authorList) {
            this.makeTitleList((String)this.authorList.getSelectedValue());
        } else if (object == this.titleList) {
            this.setBook();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.authorText) {
            this.book.setAuthor(this.authorText.getText());
        } else if (object == this.titleText) {
            this.book.setTitle(this.titleText.getText());
        } else if (object == this.seriesText) {
            this.book.setSeries(this.seriesText.getText());
        } else if (object == this.fileText) {
            this.book.setFileName(this.fileText.getText());
        } else if (object == this.imageText) {
            this.book.setImageName(this.imageText.getText());
            this.setImage();
        } else if (object == this.descriptionText) {
            this.book.setDescription(this.descriptionText.getText());
        } else if (object == this.authorList) {
            this.makeTitleList((String)this.authorList.getSelectedValue());
            this.authorList.grabFocus();
        } else if (object == this.titleList) {
            this.setBook();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

