/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Books {
    private static final String VERSION = "0.1";
    private static final String fileName = "books.dat";
    private static final Books instance = new Books();
    static ArrayList<Book> books = new ArrayList();

    private Books() {
    }

    public static Books getInstance() {
        return instance;
    }

    public void add(Book book) {
        books.add(book);
    }

    public Book get(int n) {
        return books.get(n);
    }

    public void set(int n, Book book) {
        books.set(n, book);
    }

    public void remove(int n) {
        books.remove(n);
    }

    public int size() {
        return books.size();
    }

    public boolean load() {
        books.clear();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return true;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            boolean bl = true;
            while (bufferedReader.ready() && bl) {
                Book book = new Book();
                if (book.read(bufferedReader)) {
                    books.add(book);
                    continue;
                }
                System.out.println(books.get(books.size() - 1));
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean save() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileName));
            for (int i = 0; i < books.size(); ++i) {
                books.get(i).write(bufferedWriter);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

