﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
import os
import hashlib
from io import BytesIO
from PIL import Image
from sigil_bs4 import BeautifulSoup

from PyQt5.QtWidgets import (QWidget, QPushButton, QLineEdit, QLabel,
                             QApplication, QVBoxLayout)

from PyQt5.QtCore import Qt

lineEditPrompt = "Image name"
lineEditPrompt2 = "Width From"
lineEditPrompt3 = "Width To"
defaultImageName = "fleuron.png"
width_from = "398"
width_to = "402"
darkTheme = None

class askSetting(QWidget):

    def __init__(self,
                 app=None,
                 parent=None,
                 items=None):

        super(askSetting, self).__init__(parent)

        self.app = app
        self.items = items
        #self.widthfrom = widthfrom
        #self.widthto = widthto

        layout = QVBoxLayout()

        self.lineedits = {}
        self.lineedits2 = {}
        self.lineedits3 = {}

        if darkTheme:
            self.setStyleSheet("""

* {
  background-color: #222222;
  color: #d8d8d8;
}

QLabel {
  color: #d8d8d8;
  background: transparent;
}

QLineEdit {
  color: #d8d8d8;
  padding: 4px;
  min-height: 1em;
}

QLineEdit {
  border: 1px solid #2e2e2e;
  background-color: #1f1f1f;
}

QLineEdit:disabled {
  border: 1px solid transparent;
  background-color: #282828;
}

QLineEdit:focus {
  background-color: #1f1f1f;
}

QLineEdit:focus:hover {
  border-color: #485d6f;
}

QLineEdit:hover {
  background-color: #1f1f1f;
  border-color: #555555;
}

QPushButton {
  background-color: #444444;
  border: 1px solid #444444;
  color: #d8d8d8;
  /*font-size: 12pt;*/
  padding: 3px 20px;
}

QPushButton:focus {
  background-color: #3e4f5e;
}

QPushButton:hover {
  background-color: #595959;
  border-color: #555555;
}

QPushButton:hover:focus {
  background-color: #485d6f;
  border-color: #485d6f;
}

QPushButton:focus {
  border-color: #3e4f5e;
}

QPushButton:pressed,
QPushButton:pressed:focus {
  background-color: #298ce1;
  border-color: #298ce1;
  color: white;
}
                       """)

        for key in items.keys():
            layout.addWidget(QLabel(key))
            self.lineedits[key] = QLineEdit()
            self.lineedits[key].setText(items[key])
            # enable ime input
            self.lineedits[key].inputMethodQuery(Qt.ImEnabled)
            layout.addWidget(self.lineedits[key])

            #self.lineedits2[key] = QLineEdit()
            #self.lineedits2[key].setText(widthfrom[key])
            # enable ime input
            #self.lineedits2[key].inputMethodQuery(Qt.ImEnabled)
            #layout.addWidget(self.lineedits2[key])

            #self.lineedits3[key] = QLineEdit()
            #self.lineedits3[key].setText(widthto[key])
            # enable ime input
            #self.lineedits3[key].inputMethodQuery(Qt.ImEnabled)
            #layout.addWidget(self.lineedits3[key])

        self.btn = QPushButton('OK', self)
        self.btn.clicked.connect(lambda: (self.bye(items)))
        self.btn.setFocusPolicy(Qt.StrongFocus)

        self.lineedits[key].returnPressed.connect(self.btn.click)
        #self.lineedits2[key].returnPressed.connect(self.btn.click)
        #self.lineedits3[key].returnPressed.connect(self.btn.click)

        layout.addWidget(self.btn)

        self.setLayout(layout)
        self.setWindowTitle('Settings')

    def bye(self, items):
        for key in self.lineedits.keys():
            self.items[key] = self.lineedits[key].text()
        for key in self.lineedits2.keys():
            self.widthfrom[key] = self.lineedits2[key].text()
        for key in self.lineedits3.keys():
            self.widthto[key] = self.lineedits3[key].text()

        self.close()
        self.app.exit(1)

def hash_bytestr_iter(bytesiter, hasher, ashexstr=True):
    for block in bytesiter:
        hasher.update(block)
    return hasher.hexdigest() if ashexstr else hasher.digest()


def file_as_blockiter(afile, blocksize=65536):
    with afile:
        block = afile.read(blocksize)
        while len(block) > 0:
            yield block
            block = afile.read(blocksize)

def run(bk):

    if sys.platform == "darwin":
        print("Plugin using PyQt5, bundled Python may not work")

    temp_dir = bk._w.ebook_root

    items = {lineEditPrompt:  defaultImageName,
             lineEditPrompt2: width_from,
             lineEditPrompt3: width_to}


    app = QApplication(sys.argv)
    ask = askSetting(app=app, items=items)
    ask.show()

    rtnCode = app.exec_()
    # If press OK button  rtnCode should be 1
    if rtnCode != 1:
        print('User abort by closing Setting dialog')
        return -1

    data_from_form = list(items.values())
    mainImageName = data_from_form[0]
    main_width_from = int(data_from_form[1])
    main_width_to = int(data_from_form[2])
    #main_width_from = ''.join(list(widthfrom.values()))
    #main_width_to = ''.join(list(widthto.values()))

    main_img_bookpath = None
    renamed_files = 0

    # Loop to detect hash for main image
    for (html_id, file_href) in bk.text_iter():
        html = bk.readfile(html_id)

        # load html code into BeautifulSoup
        soup = BeautifulSoup(html, 'html.parser')

        # look for images
        img_tags = soup.find_all('img')

        for img in img_tags:
            if 'src' in img.attrs:
                href = img['src']
                base_name = os.path.basename(href)
                if base_name == mainImageName:
                    id = bk.basename_to_id(base_name)
                    main_img_bookpath = "OEBPS/" + href
                    if bk.launcher_version() >= 20190927:
                        main_img_bookpath = bk.id_to_bookpath(id)
                    main_hash = hash_bytestr_iter(file_as_blockiter(open(os.path.join(temp_dir, main_img_bookpath.replace("/",os.sep)), 'rb')), hashlib.sha256())
                    break

    if main_img_bookpath is None:
        print("\nFile {} not exist.".format(mainImageName))
        return -1

    # process file list (main loop)
    for (html_id, file_href) in bk.text_iter():
        file_name = os.path.basename(file_href)
        print('Processing {}...'.format(file_name))
        html = bk.readfile(html_id)

        # load html code into BeautifulSoup
        soup = BeautifulSoup(html, 'html.parser')
        orig_soup = str(soup)

        # look for images
        img_tags = soup.find_all('img')

        for img in img_tags:
            if 'src' in img.attrs:
                href = img['src']
                base_name = os.path.basename(href)
                id = bk.basename_to_id(base_name)
                img_bookpath = "OEBPS/" + href
                if bk.launcher_version() >= 20190927:
                    img_bookpath = bk.id_to_bookpath(id)
                if main_img_bookpath == img_bookpath:
                    continue

                if id:
                    hash = False
                    image_hash = hash_bytestr_iter(file_as_blockiter(open(os.path.join(temp_dir, img_bookpath.replace("/",os.sep)), 'rb')), hashlib.sha256())
                    if image_hash == main_hash:
                        img['src'] = href.replace(base_name, mainImageName)
                        print('{} renamed to {} [hash]'.format(base_name, mainImageName))
                        renamed_files += 1
                        hash = True
                    if (main_width_from > 0) and (main_width_to > 0) and (hash == False):
                        # get image file size
                        imgdata = bk.readfile(id)
                        img_data = Image.open(BytesIO(imgdata)).convert('L')
                        width, height = img_data.size
                        if (width >= main_width_from)  and (width <= main_width_to):
                            img['src'] = href.replace(base_name, mainImageName)
                            print('{} renamed to {} [width]'.format(base_name, mainImageName))
            else:
                print(img['src'] + ' skipped! (empty img tag)\n')

        if str(soup) != orig_soup:
            bk.writefile(html_id, str(soup.prettyprint_xhtml()))
            print('{} updated\n'.format(file_name))

    if renamed_files > 0:
        print('\n{} renamed image(s)\n'.format(renamed_files))

    print('\nPlease click OK to close the Plugin Runner window.')

    return 0

def main():
    print('I reached main when I should not have\n')
    return -1


if __name__ == "__main__":
    sys.exit(main())
