import os
import re
import sys
import tarfile
import unix_ar
import urllib
from io import BytesIO
from urllib import request

DISTRO = "jessie"
PATH = "/mnt/us/extensions"

PYTHON_VER = "3.4"

PYTHON = ["python"+PYTHON_VER, "python"+PYTHON_VER+"-minimal", "libpython"+PYTHON_VER+"-minimal","libpython"+PYTHON_VER, "libpython"+PYTHON_VER+"-stdlib"]

GTK = ["python3-gi","python3-gi-cairo","gir1.2-gtk-3.0", "gir1.2-glib-2.0", "libffi6", "libgirepository-1.0-1", "libglib2.0-0","libpcre3", "libselinux1", "zlib1g", "libcairo-gobject2", "libcairo2", "libfontconfig1", "libfreetype6", "libpixman-1-0", "libpng12-0", "libx11-6", "libxcb-render0", "libxcb-shm0", "libxcb1", "libxext6", "libxrender1", "libexpat1", "libx11-data", "libxau6", "libxdmcp6", "gir1.2-atk-1.0", "gir1.2-freedesktop", "gir1.2-gdkpixbuf-2.0", "gir1.2-pango-1.0", "libgtk-3-0", "libgtk-3-common", "libatk1.0-0", "libgdk-pixbuf2.0-0", "libpango-1.0-0", "libpangocairo-1.0-0", "libpangoft2-1.0-0", "libpangoxft-1.0-0","libharfbuzz0b","libxft2", "libxrender1","libatk-bridge2.0-0", "libcolord2","liblcms2-2", "libudev1", "libjson-glib-1.0-0","librest-0.7-0", "libsoup2.4-1","libxml2","liblzma5","libsqlite3-0", "libwayland-cursor0","libwayland-client0","libxkbcommon0","libxrandr2", "libxcomposite1","libxcursor1","libxdamage1","libxfixes3","libxi6","libxinerama1","gobject-introspection","libgirepository-1.0-1","libatspi2.0-0", "libthai0"]

USER = []
PACKAGES = [PYTHON,GTK]

os.system("mkdir -p python")
os.system("mkdir -p cache")
cached_packages = os.listdir("cache")

def generate_cache(cache_file):
    with open(".cached_packages") as cache_file:
        data = cache_file.readlines()
        data = [line[:-1].split(",") for line in data]
        output = dict((package[0],package[1]) for package in data)
        cache_file.close()
    return output
    
cache_data = generate_cache(".cached_packages")   
cache_file = open(".cached_packages","a")

def getPackageUrl(name):
  
  www = request.urlopen("http://packages.debian.org/{0}/armel/{1}/download".format(DISTRO, name));
  content = www.read().decode()
  default = re.compile("(<a href=(.*)>ftp.us.debian.org/debian</a>|<a href=(.*)>security.debian.org/debian-security</a>)")
  default_url = default.findall(content)
  if default_url:
    results = [x for x in default_url[0] if x]
    return results[-1]
  else:
    raise Exception(f"Package not found: {name}")

def extract_ar(in_file, member):
    in_file.seek(member.offset + 60, 0)
    data = BytesIO()
    for pos in range(0, member.size, 4096):
        chunk = in_file.read(min(4096, member.size - pos))
        data.write(chunk)
    data.flush()
    data.seek(0)
    return data 
    
def downloadAndUnpackDeb(name):
    print(f"Downloading {name}...")
    if name in cache_data:
        print("File found in cache")
        with open(f"cache/{cache_data[name]}", "rb") as cached:
            r_data = BytesIO(cached.read())
            cached.close()
    else:
        p_name = getPackageUrl(name)
        f_name = p_name.split("/")[-1][0:-1]
        cache_file.write(f"{name},{f_name}\n")
        r = request.urlopen(p_name.strip('\'"'))
        response = r.read()
        with open(f"cache/{f_name}",'wb') as cache:
            cache.write(response)
            cache.close()
        r_data = BytesIO(response) 

    t = unix_ar.open(r_data)
    for i in t.infolist():
        if i.name == b'data.tar.xz' or i.name == b'data.tar.gz':
            testdata = extract_ar(t._file,i)
            y = tarfile.open(fileobj=testdata,mode="r")
            print(f"Unpacking {name}...")
            #print(y.getnames())
            y.extractall(path="python")

def repack():
  os.chdir("python")
  os.system("mkdir -p usr/bin")
  
  p_lines = ["#!/bin/sh\n",
            f"export GI_TYPELIB_PATH=/mnt/us/extensions/python/usr/lib/arm-linux-gnueabi/gobject-introspection/girepository-1.0:/mnt/us/extensions/python/usr/lib/gi-repository-1.0:/mnt/us/extensions/python/lib"
            f"export PYTHONPATH={PATH}/python/usr/lib/python{PYTHON_VER}\n",
            f"export LD_LIBRARY_PATH={PATH}/python/usr/lib:{PATH}/python/usr/lib/arm-linux-gnueabi:{PATH}/python/lib/arm-linux-gnueabi:$LD_LIBRARY_PATH\n",
            f"python{PYTHON_VER} $@\n"]

  with open("usr/bin/python", "w") as python_file:
    for line in p_lines:
        python_file.write(line)
    python_file.close() 

  os.system("chmod 755 usr/bin/python")

  e = open("pythonenv", "w")
  e.write("#!/bin/sh\n")
  e.write("export PATH="+PATH+"/python/usr/bin/:$PATH\n")
  e.close()

def main():
  print("Downloading selected packages...")
  for set in PACKAGES:
    for package in set:
      downloadAndUnpackDeb(package)

  print("Downloading done. Packaging...")
  repack()
  cache_file.close()
  print("Done. Now unpack python.tar.gz file to "+PATH+" directory on your Kindle.")

main()
