#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#

import os, os.path, sys, shutil, inspect
from tempfile import mkdtemp                  
from cutils import *
from dialog import UserDialog
import options
from updater import updateCheck
import tkinter as tk

try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup

SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3569579&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass

    return False    
    
def runUserDialog(bk):
    root = tk.Tk()
    root.title('AddKindleMediaQueries')
    root.resizable(width=True, height=True)
    if not sys.platform.startswith('darwin'):
        img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
        root.tk.call('wm','iconphoto', root._w, img)
    UserDialog(root).pack(fill=tk.BOTH, expand=True)
    root.mainloop()
    return(0)    
    
def run(bk):  
    print('Python version: ', sys.version, '\n')
    print('Running AddKindleMediaQueries...Please wait\n') 
    
    if is_connected:
        # check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new version of this plugin is now available from MR - v" + latest_version
    
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()
    else:
        epubversion = BeautifulSoup(bk.get_opf(), 'lxml').find('package')['version']
    
    # check for correct epub version(epub 2)
    if epubversion == '3.0':
        msg = "Epub 3.0 ebooks are not supported. This plugin requires a valid epub 2.0 ebook as input. " + \
              "Please try again."        
        show_msgbox('Incompatible Epub Version', msg, msgtype="error")
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(0)                       
    
    # create a working dir
    WDIR = mkdtemp()
    
    # copy the epub CSS files to the working dir
    s_ids, s_fnames = copyCSSFiles2Dir(bk, WDIR) 
    t_ids, t_fnames = copyTextFiles2Dir(bk, WDIR)
    i_ids, i_fnames = copyImageFiles2Dir(bk, WDIR)   
    
    # check that the file is an epub with stylesheets
    if len(s_fnames) == 0:  
        msg = 'No stylesheets were found. This plugin requires a valid epub(with stylesheets) as input. Please try again.'
        show_msgbox('No Stylesheets Found', msg, msgtype='info')
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(0)  
    
    options.CSS_FNAMES = s_fnames
    runUserDialog(bk)    
    
    if options.SYS_EXIT == True:
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(0)
    
    # process all tasks
    processAllTasks(bk, WDIR, t_ids, t_fnames, s_ids, s_fnames)
   
    if options.SYS_EXIT == True:
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(0)
        
    print('\n -- Completed SUCCESSFULLY...')
    # remove the temp work dir
    cleanExit(WDIR)
    return(0)                

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())    