import time

from PyQt5.QtCore import Qt, QModelIndex, pyqtSignal, pyqtSlot, QSize
from PyQt5.QtGui import QPixmap, QFont, QMovie, QColor
from PyQt5.QtWidgets import QWidget, QLabel, QVBoxLayout, QGroupBox, QPushButton, QHBoxLayout, QComboBox, QSizePolicy, \
    QGridLayout, QLineEdit

from calibre_plugins.manga.thread_task.build_volume_task import BuildVolumeTask
from calibre_plugins.manga.thread_task.parallel_task import ParallelTask
from calibre_plugins.manga.thread_task.request_chapter_content_task import RequestChapterContentTask
from calibre_plugins.manga.thread_task.request_chapter_list_task import RequestChapterListTask
from calibre_plugins.manga.thread_task.task_manager import TaskManager
from calibre_plugins.manga.utils import Utils
from calibre_plugins.manga.view.chapter_list_view import ChapterListView


class MangaPage(QWidget):

    complete_build = pyqtSignal(object, str)

    def __init__(self, parent=None):
        QWidget.__init__(self, parent)
        self.root_layout = QGridLayout()

        self.cover_view = QLabel()
        self.root_layout.addWidget(self.cover_view, 0, 3, 5, 1)

        # self.detail_page = QGroupBox("Manga Details:")
        self.title_label = QLabel("Manga Title")
        self.title_label_font = QFont()
        self.title_label_font.setPointSize(15)
        self.title_label.setFont(self.title_label_font)
        self.root_layout.addWidget(self.title_label, 0, 0, 1, 2)

        self.description_label = QLabel("Description")
        self.description_label.setWordWrap(True)
        # self.description_label.setFixedHeight(54)
        self.description_label.setAlignment(Qt.AlignTop)
        self.root_layout.addWidget(self.description_label, 1, 0, 4, 2)

        self.chapter_list = ChapterListView()
        self.chapter_list.on_selection_change.connect(self.on_chapter_selection_change)
        self.root_layout.addWidget(self.chapter_list, 5, 0, 20, 4)

        self.loading_view = QLabel()
        # palette = self.loading_view.palette()
        self.loading_view.setAlignment(Qt.AlignHCenter | Qt.AlignVCenter);
        self.loading_view.setStyleSheet("QLabel { background-color : #44000000; }")

        # palette.setColor(self.loading_view.backgroundRole(), QColor(255,255,255,255))
        # palette.setColor(self.loading_view.foregroundRole(), QColor(255, 255, 255, 255))
        # self.loading_view.setPalette(palette)

        # self.loading_animation = QMovie("images/load-animation.gif")
        # self.loading_animation.setScaledSize(QSize(50, 50))
        # self.loading_view.setMovie(self.loading_animation)
        # self.loading_animation.start()
        self.root_layout.addWidget(self.loading_view, 5, 0, 20, 4)
        self.show_chapter_load_animation(False)

        # self.root_layout.removeWidget(self.loading_view)

        self.create_footer()

        self.setLayout(self.root_layout)

    def show_chapter_load_animation(self, show=True):
        self.loading_view.setVisible(show)

    def create_footer(self):
        self.footer = QWidget()

        self.footer_layout = QHBoxLayout()
        self.footer_layout.setContentsMargins(0, 0, 0, 0)
        self.footer.setLayout(self.footer_layout)

        self.dir_button = QPushButton(Utils.get_sub_folder_book())

        # self.dir_button.setEditable(False)
        # self.dir_button.addItem(Utils.get_sub_folder_book())
        self.dir_button.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Preferred)
        self.dir_button.clicked.connect(self.on_dir_button_clicked)
        self.footer_layout.addWidget(self.dir_button)

        self.name_field = QLineEdit()
        # self.name_field.setEnabled(False)
        self.footer_layout.addWidget(self.name_field)

        self.format_field = QComboBox()
        self.format_field.addItem(".cbz")
        self.format_field.setFixedWidth(50)
        self.footer_layout.addWidget(self.format_field)

        self.download_button = QPushButton()
        self.download_button.setFixedWidth(100)
        self.download_button.setText("Download")
        self.download_button.setEnabled(False)
        self.download_button.clicked.connect(self.on_download_button_clicked)
        self.footer_layout.addWidget(self.download_button)

        self.root_layout.addWidget(self.footer, 30, 0, 1, 4)

    def on_dir_button_clicked(self):
        Utils.show_in_explorer(Utils.get_sub_folder_book())

    def on_chapter_selection_change(self, chapters_selected):
        if len(chapters_selected) > 0:
            manga = chapters_selected[0].manga_container
            self.name_field.setText("{} [{}-{}]".format(Utils.make_filename_safe(manga.name), chapters_selected[0].c_number, chapters_selected[len(chapters_selected) - 1].c_number))
            self.download_button.setText("Download ({})".format(len(chapters_selected)))
            self.download_button.setEnabled(True)
        else:
            self.name_field.setText("")
            self.download_button.setText("Download")
            self.download_button.setEnabled(False)


    def set_manga(self, manga):
        self.manga = manga
        self.chapter_list.clearSelection()
        self.update_manga_page()

    def update_manga_page(self):
        if self.manga.cover_local is not None:
            pixmap = QPixmap(self.manga.cover_local)
            self.cover_view.setVisible(True)
            self.cover_view.setPixmap(pixmap)
            self.cover_view.setScaledContents(True)
            self.cover_view.setFixedSize(100, 160)
        else:
            self.cover_view.setVisible(False)
        self.title_label.setText(self.manga.name)
        self.description_label.setText(self.manga.description)

        # if self.manga.chapters is None:
        task = RequestChapterListTask(self.manga)
        task.on_completed.connect(self.on_request_chapter_list_completed)
        task.start()
        self.show_chapter_load_animation()
        # self.chapter_list.clear()
        # else:
        #     self.chapter_list.set_chapters(self.manga.chapters)

    def on_download_button_clicked(self):
        print("start download")
        filename = self.name_field.text()
        filename = Utils.make_filename_safe(filename)

        parallel_task = ParallelTask()
        self.parallel_task = parallel_task

        for ch in self.chapter_list.selected_chapters:
            download_task = RequestChapterContentTask(ch)
            similar = TaskManager.find_similar_task(download_task)
            if similar is None:
                parallel_task.add_task(download_task)

        build_task = BuildVolumeTask(self.chapter_list.selected_chapters, filename=filename)
        build_task.on_completed.connect(self.on_complete_build)
        parallel_task.chain(build_task)
        parallel_task.on_process_update.connect(self.on_download_process_update)

        parallel_task.start()

    def on_request_chapter_list_completed(self, task):
        self.show_chapter_load_animation(False)
        self.chapter_list.set_chapters(task.get_results())

    def on_download_process_update(self, task, current_process, total, verbal):
        # print("Progress: {0:.0f}%/{1}".format(current_process*100/total, verbal))
        self.chapter_list.chapter_list_model.dataChanged.emit(QModelIndex(), QModelIndex())

    def on_complete_build(self, task, results):
        self.complete_build.emit(task, results)
