from PyQt5 import Qt, QtCore
from PyQt5.QtCore import QSize
from PyQt5.QtGui import QBrush, QColor, QPainter
from PyQt5.QtWidgets import QStyledItemDelegate, QApplication

DISPLAY_SUB_TITLE_ROLE = 100


class MangaListDelegate(QStyledItemDelegate):

    def sizeHint(self, option, index):
        return self.control_size(option, index)

    def control_size(self, option, index):
        return self.drawControl(None, option, index)

    def drawControl(self, painter, option, index):
        # type: (QPainter, QStyleOptionViewItem, QModelIndex) -> QSize
        if option is not None:
            widget = option.widget
            if widget is not None:
                style = widget.style()
            else:
                style = QApplication.style()
        if painter is not None:
            painter.save()
            painter.setClipRect(option.rect)

            # checkRect = style.proxy().subElementRect(Qt.QStyle.SE_ItemViewItemCheckIndicator, option, widget)
            # iconRect = style.proxy().subElementRect(Qt.QStyle.SE_ItemViewItemDecoration, option, widget)
            # textRect = style.proxy().subElementRect(Qt.QStyle.SE_ItemViewItemText, option, widget)

            # // draw the background
            style.proxy().drawPrimitive(Qt.QStyle.PE_PanelItemViewItem, option, painter, widget)
            painter.restore()

        pos_x, pos_y = option.rect.x(), option.rect.y()

        if painter is not None:
            painter.save()
            rect = Qt.QRect(pos_x, pos_y, 50, 80)
            painter.setClipRect(rect)
            option.icon.paint(painter, rect.x(), rect.y(), rect.width(), rect.height(), QtCore.Qt.AlignTop)
            painter.restore()

        # if painter is not None and index is not None:
        #     image = index.data(QtCore.Qt.DecorationRole)
        #     if image is not None:
        #         painter.save()
        #         size = image.size()
        #         painter.setClipRect(Qt.QRect(pos_x, pos_y, 50, 80))
        #         painter.drawImage(Qt.QRect(pos_x, pos_y, 50, 50.0 * size.height()/size.width()), image)
        #         painter.restore()

        pos_x += 50

        font = Qt.QFont(QApplication.font())
        font.setPointSize(12)

        if painter is not None:
            painter.save()
            painter.setFont(font)

        font_metrics = Qt.QFontMetrics(font)

        pos_y += font_metrics.height()
        if painter is not None:
            # gradient = Qt.QLinearGradient(0, 0, 0, 10)
            # gradient.setColorAt(0, QColor(255, 255, 255, 255))
            # gradient.setColorAt(1, QColor(255, 255, 255, 0))
            # brush = QBrush(gradient)
            # painter.fillRect(0, 0, 200, 20, brush)
            painter.drawText(pos_x, pos_y, option.text)

        pos_y += font_metrics.descent()

        font.setPointSize(10)
        font_metrics = Qt.QFontMetrics(font)
        pos_y += font_metrics.height()
        data = index.data(DISPLAY_SUB_TITLE_ROLE)
        if painter is not None:
            painter.setFont(font)
            painter.drawText(pos_x + 2, pos_y, data)

        pos_y += font_metrics.descent()

        if painter is not None:
            painter.restore()

        pos_y += 30

        return Qt.QSize(pos_x, pos_y)

    def paint(self, painter, option, index):
        self.initStyleOption(option, index)

        self.drawControl(painter, option, index)
