from PyQt5.QtWidgets import QWidget, QGridLayout, QLabel, QVBoxLayout

from calibre_plugins.manga.model.chapter_list_model import ChapterListModel
from calibre_plugins.manga.thread_task.download_manager import DownloadManager
from calibre_plugins.manga.thread_task.request_downloaded_chapter_list_task import RequestDownloadedChapterListTask
from calibre_plugins.manga.view.chapter_list_view import ChapterListView


class DownloadPage(QWidget):

    def __init__(self):
        super(DownloadPage, self).__init__()

        self.root_layout = QGridLayout()
        self.setLayout(self.root_layout)

        self.menu = QWidget()
        self.menu.setFixedWidth(200)
        self.menu_layout = QVBoxLayout()

        self.menu.setLayout(self.menu_layout)
        self.root_layout.addWidget(self.menu, 0, 0)

        self.chapter_list_view = ChapterListView()
        self.root_layout.addWidget(self.chapter_list_view, 0, 1)

        DownloadManager.register_chapter_complete_slot(self.on_chapter_download_complete)

        task = RequestDownloadedChapterListTask()
        task.on_completed.connect(self.on_request_chapter_list_complete)
        task.start()

    def on_request_chapter_list_complete(self, task, results):
        self.model = ChapterListModel(results)
        self.chapter_list_view.setModel(self.model)

    def on_chapter_download_complete(self, chapter):
        self.model.add(chapter)



