import webbrowser

from PyQt5 import Qt, QtCore
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtGui import QPainter, QColor
from PyQt5.QtWidgets import QListView, QAbstractItemView, QLabel, QApplication

from calibre_plugins.manga.model.chapter_list_model import ChapterListModel, URL_ROLE
from calibre_plugins.manga.view.chapter_list_delegate import ChapterListDelegate


class ChapterListView(QListView):

    on_selection_change = pyqtSignal(object)

    def __init__(self):
        super(ChapterListView, self).__init__()
        self.selected_chapters = []

        self.setSelectionMode(QAbstractItemView.ExtendedSelection)
        self.chapter_list_model = ChapterListModel()
        self.setModel(self.chapter_list_model)
        self.selectionModel().selectionChanged.connect(self.on_chapter_selected)
        self.chapter_list_delegate = ChapterListDelegate()
        self.setItemDelegate(self.chapter_list_delegate)
        self.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOn)
        self.doubleClicked.connect(self.on_double_click_item)

    def on_double_click_item(self, index):
        url = self.chapter_list_model.data(index, URL_ROLE).value()
        webbrowser.open_new(url)

    def on_chapter_selected(self, selected):
        selected_indexes = self.selectionModel().selectedIndexes()
        if len(selected_indexes) > 0:
            self.selected_chapters = []
            for i in selected_indexes:
                self.selected_chapters.append(self.chapter_list_model.get_chapter(i))
            self.selected_chapters.sort(key=lambda x: x.c_number, reverse=False)
            self.on_selection_change.emit(self.selected_chapters)
        else:
            self.on_selection_change.emit([])

    def set_chapters(self, chapters):
        self.chapter_list_model.clear()
        for chapter in chapters:
            self.chapter_list_model.add(chapter)

    def clear(self):
        self.chapter_list_model.clear()

    def paintEvent(self, painter_event):
        QListView.paintEvent(self, painter_event)
        # option = self.viewOptions()
        # painter = QPainter(self.viewport())
        # font = Qt.QFont(QApplication.font())
        # font.setPointSize(40)
        #
        # if painter is not None:
        #     painter.save()
        #     painter.setFont(font)
        # painter.fillRect(0, 0, self.viewport().width(), self.viewport().height(), QColor(50,50,50,100))
        # painter.restore()
