from PyQt5 import Qt
from PyQt5.QtCore import QModelIndex
from PyQt5.QtGui import QPainter
from PyQt5.QtWidgets import QStyledItemDelegate, QApplication, QStyleOptionViewItem

from calibre_plugins.manga.model.chapter_list_model import DISPLAY_DOWNLOAD_PROGRESS

DISPLAY_SUB_TITLE_ROLE = 100


class ChapterListDelegate(QStyledItemDelegate):

    def sizeHint(self, option, index):
        return self.control_size(option, index)

    def control_size(self, option, index):
        return self.drawControl(None, option, index)

    def drawControl(self, painter, option, index):
        # type: (QPainter, QStyleOptionViewItem, QModelIndex) -> None
        if option is not None:
            widget = option.widget
            if widget is not None:
                style = widget.style()
            else:
                style = QApplication.style()
        if painter is not None:
            painter.save()
            painter.setClipRect(option.rect)

            # // draw the background
            style.proxy().drawPrimitive(Qt.QStyle.PE_PanelItemViewItem, option, painter, widget)
            painter.restore()

        pos_x, pos_y = option.rect.x(), option.rect.y()

        font = Qt.QFont(QApplication.font())
        font.setPointSize(12)

        if painter is not None:
            painter.save()
            painter.setFont(font)

        font_metrics = Qt.QFontMetrics(font)

        pos_y += font_metrics.height()
        if painter is not None:
            painter.drawText(pos_x, pos_y, option.text)

        pos_y += font_metrics.descent()

        font.setPointSize(10)
        font_metrics = Qt.QFontMetrics(font)
        pos_y += font_metrics.height()
        data = index.data(DISPLAY_SUB_TITLE_ROLE)
        if painter is not None and data is not None:
            painter.setFont(font)
            painter.drawText(pos_x + 2, pos_y, data)

        data = index.data(DISPLAY_DOWNLOAD_PROGRESS)
        if painter is not None and data is not None:
            font_metrics = Qt.QFontMetrics(font)
            progress_text_width = font_metrics.boundingRect(data).width()
            painter.setFont(font)
            painter.drawText(option.widget.width() - progress_text_width - 30, pos_y, data)

        pos_y += font_metrics.descent()

        if painter is not None:
            painter.restore()

        return Qt.QSize(pos_x, pos_y)

    def paint(self, painter, option, index):
        self.initStyleOption(option, index)

        self.drawControl(painter, option, index)