from __future__ import absolute_import, division, print_function, unicode_literals

__license__   = 'GPL v3'
__copyright__ = ''
__docformat__ = ''

if False:
    get_icons = get_resources = None

from calibre.gui2.actions import InterfaceAction
from calibre_plugins.manga.manga_finder_dialog import MangaFinderDialog

class InterfacePlugin(InterfaceAction):

    name = 'Manga Finder'

    action_spec = ('Manga', None,
            'Run Manga Finder', 'Ctrl+Shift+F1')

    def genesis(self):
        icon = get_icons('images/icon.png')

        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_dialog)

    def show_dialog(self):
        base_plugin_object = self.interface_action_base_plugin
        do_user_config = base_plugin_object.do_user_config

        d = MangaFinderDialog(self.gui, self.qaction.icon(), do_user_config)
        d.show()

    def apply_settings(self):
        from calibre_plugins.manga.config import prefs

