import unittest
import time

from PyQt5 import QtCore
from PyQt5.QtWidgets import QApplication

from calibre_plugins.manga.manga_api.manga_container import MangaContainer
from calibre_plugins.manga.manga_api.mangarock_API import MangarockAPI
from calibre_plugins.manga.thread_task.request_chapter_content_task import RequestChapterContentTask
from calibre_plugins.manga.thread_task.method_task import MethodTask
from calibre_plugins.manga.thread_task.parallel_task import ParallelTask
from calibre_plugins.manga.thread_task.request_chapter_list_task import RequestChapterListTask

mangarock = MangarockAPI()


class TestDownloadChapterTask(QtCore.QObject):
    test_task_list = []

    def test_download_task(self):
        self.manga_container = MangaContainer(mangarock, "mrs-serie-173467")

        self.chapter_list_task = RequestChapterListTask(self.manga_container)
        self.set_task = MethodTask(self.setup_download)
        self.chapter_list_task.chain(self.set_task)

        self.chapter_list_task.start()

    def setup_download(self):
        chapter_list = [self.manga_container.chapters[11], self.manga_container.chapters[12]]

        parallel_task = ParallelTask()
        parallel_task.on_process_update.connect(self.on_parallel_update)
        parallel_task.on_completed.connect(self.on_test1_complete)
        self.set_task.chain(parallel_task)
        for ch in chapter_list:
            download_task = RequestChapterContentTask(ch)
            parallel_task.add_task(download_task)

    def on_parallel_update(self, task, current, total):
        print current, total, task.results
        pass

    def on_test1_complete(self, task):
        print("Completed1")


if __name__ == '__main__':
    app = QApplication([])
    obj = TestDownloadChapterTask()
    obj.test_download_task()
    app.exec_()