import unittest
import time

from PyQt5 import QtCore
from PyQt5.QtWidgets import QApplication

from calibre_plugins.manga.thread_task.method_task import MethodTask
from calibre_plugins.manga.thread_task.parallel_task import ParallelTask


def simulate_long_running_task():
    print("simulate task")
    time.sleep(.5)

def simulate_long_running_task_with_error():
    print("simulate task with error")
    time.sleep(.5)
    raise Exception('Some type of error')

class TestObj(QtCore.QObject):
    test_task_list = []

    def on_test1_parallel_complete(self, task):
        print("Completed1")
        self.test_parallel_task_with_error()

    def test_parallel_task(self):
        print("test parallel task without errors:")
        for i in range(5):
            method_task = MethodTask(simulate_long_running_task)
            self.test_task_list.append(method_task)

        parallel_task = ParallelTask(self.test_task_list)
        parallel_task.on_completed.connect(self.on_test1_parallel_complete)
        parallel_task.start()

    def on_test2_parallel_error(self, task):
        print("error signal working")
        QApplication.instance().quit()

    def on_test2_parallel_completed(self):
        print("fail test2")
        QApplication.instance().quit()

    def test_parallel_task_with_error(self):
        print("test parallel task with errors:")
        self.test_task_list = []
        for i in range(3):
            method_task = MethodTask(simulate_long_running_task)
            self.test_task_list.append(method_task)

        self.test_task_list.append(MethodTask(simulate_long_running_task_with_error))

        parallel_task = ParallelTask(self.test_task_list)
        parallel_task.on_error.connect(self.on_test2_parallel_error)
        parallel_task.on_completed.connect(self.on_test2_parallel_completed)
        parallel_task.start()


if __name__ == '__main__':
    app = QApplication([])
    obj = TestObj()
    obj.test_parallel_task()
    app.exec_()