import unittest
import time

from PyQt5 import QtCore
from PyQt5.QtWidgets import QApplication

from calibre_plugins.manga.thread_task.method_task import MethodTask


def method1():
    time.sleep(1)
    print("method without args")

def method2(str1):
    time.sleep(1)
    print("method with str({}) ".format(str1))


class TestObj(QtCore.QObject):
    test_task_list = []

    def on_test1_method_complete(self, task):
        print("Completed1")
        self.test2()

    def test1(self):
        print("test method task without args:")

        method_task = MethodTask(method1)
        method_task.on_completed.connect(self.on_test1_method_complete)
        method_task.start()

    def on_test2_parallel_completed(self):
        print("Completed2")
        QApplication.quit()

    def test2(self):
        print("test method task with args:")

        method_task = MethodTask(method2, ("test string",))
        method_task.on_completed.connect(self.on_test2_parallel_completed)
        method_task.start()


if __name__ == '__main__':
    app = QApplication([])
    obj = TestObj()
    obj.test1()
    app.exec_()