from PyQt5 import QtCore
from PyQt5.QtWidgets import QApplication

from calibre_plugins.manga.manga_api.manga_container import MangaContainer
from calibre_plugins.manga.thread_task.request_chapter_content_task import RequestChapterContentTask
from calibre_plugins.manga.thread_task.method_task import MethodTask
from calibre_plugins.manga.thread_task.parallel_task import ParallelTask
from calibre_plugins.manga.thread_task.request_manga_cover_task import RequestMangaCoverTask


class TestMangaCoverTask(QtCore.QObject):
    test_task_list = []

    def test_request_task(self):
        self.manga_container = MangaContainer("mrs-serie-173467")
        self.manga_container.cover = "https://f01.mrcdn.info/file/mrportal/j/3/8/3/nE.ffeWKPZd.jpg"

        self.request_task = RequestMangaCoverTask(self.manga_container)
        self.request_task.on_completed.connect(self.on_test1_complete)
        self.request_task.start()

    def on_test1_complete(self, task):
        print("Completed1")
        print(self.manga_container.cover_local)


if __name__ == '__main__':
    app = QApplication([])
    obj = TestMangaCoverTask()
    obj.test_request_task()
    app.exec_()