from PyQt5 import QtCore

try:
    from Queue import Queue
except:
    import queue as Queue

from PyQt5.QtCore import QThreadPool, QObject, QRunnable, QThread

mutex = QtCore.QMutex()


class TaskManager(QThread):
    __instance = None

    queued_task_list = []
    running_task_list = []

    @staticmethod
    def get_instance():
        if TaskManager.__instance is None:
            TaskManager()
        return TaskManager.__instance

    def __init__(self):
        if TaskManager.__instance is not None:
            raise Exception("This class is a singleton!")
        QObject.__init__(self)
        TaskManager.__instance = self
        # self.runnable = None

        self.thread_pool = QThreadPool(self)
        self.setObjectName("Task Manager")
        self.start()

    def add_task(self, task, single_only=False):
        # type: (BaseTask, bool) -> None
        task.on_completed.connect(self._on_task_complete)
        mutex.lock()
        if single_only:
            need_to_remove_list = []
            for i in TaskManager.queued_task_list:
                if type(i) == type(task):
                    need_to_remove_list.append(i)
            for r in need_to_remove_list:
                TaskManager.queued_task_list.remove(r)

        TaskManager.queued_task_list.append(task)
        mutex.unlock()
        self.quit()

        # self.thread_pool.start(_TaskManager_EventLoop())

    @staticmethod
    def find_similar_task(task):
        if task in TaskManager.queued_task_list:
            return task
        mutex.lock()
        for running_task in TaskManager.running_task_list:
            if running_task == task and not running_task.is_completed():
                mutex.unlock()
                return running_task
        mutex.unlock()
        return None

    def get_running_tasks(self):
        return self.running_task_list

    def remove_task(self, task):
        mutex.lock()
        if task in self.queued_task_list:
            self.queued_task_list.remove(task)
        mutex.unlock()

    def _on_task_complete(self, task):
        mutex.lock()
        need_to_remove_list = []
        for task in self.running_task_list:
            if task.is_completed() or task.get_error():
                need_to_remove_list.append(task)
        for task in need_to_remove_list:
            self.running_task_list.remove(task)
        mutex.unlock()
        self.quit()
        #
        # TaskManager.getInstance().thread_pool.start(_TaskManager_EventLoop())

    def run(self):
        while True:
            task = self.find_available_task()

            if task is not None:
                mutex.lock()
                if task in TaskManager.queued_task_list:
                    TaskManager.queued_task_list.remove(task)
                    TaskManager.running_task_list.append(task)

                    task.init_runnable()
                    self.thread_pool.start(task.runnable)
                mutex.unlock()

            self.exec_()
            # print("aaa")

    def find_available_task(self):
        mutex.lock()
        queued_task_list = list(TaskManager.queued_task_list)
        running_task_list = list(TaskManager.running_task_list)
        mutex.unlock()
        for task in queued_task_list:
            invalid = False
            parallel_limit = task.get_parallel_limit()
            if parallel_limit == 0:
                return task
            counter = 0
            for running_task in running_task_list:
                if type(task) == type(running_task):
                    counter += 1
                if counter >= parallel_limit:
                    invalid = True
                    break
            if not invalid:
                return task
        return None

