from PyQt5.QtCore import pyqtSignal

from calibre_plugins.manga.thread_task.base_task import BaseTask, BaseTaskRunnable

try:
    from calibre_plugins.manga.manga_api import mangarock
except ImportError:
    from calibre_plugins.manga.manga_api import mangarock_API


class RequestMangaQuickListTask(BaseTask):

    _parallel_limit = 0

    def __init__(self, module, search_string):
        BaseTask.__init__(self)
        self.module = module
        self.search_string = search_string

    def get_runnable(self):
        return _RequestMangaQuickListTaskRunnable(self)


class _RequestMangaQuickListTaskRunnable(BaseTaskRunnable):

    def execute(self):
        module = self.task.module
        self.task.results = module.get_quick_search(self.task.search_string)
