import os

from PyQt5.QtGui import QImage, QIcon

from calibre_plugins.manga.utils import Utils

try:
    from urllib2 import urlopen, Request
except:
    from urllib.request import urlopen, Request

from PyQt5 import QtCore

from calibre_plugins.manga.thread_task.base_task import BaseTask, BaseTaskRunnable
mutex = QtCore.QMutex()


def _download(url):
    req = Request(url)
    req.add_header("User-Agent", "")
    try:
        response = urlopen(req)
        return response.read()
    except:
        print("Can't download:", url)
        return None


class RequestMangaCoverTask(BaseTask):

    _parallel_limit = 5

    def __init__(self, manga_container):
        # type: (AnyStr) -> None
        BaseTask.__init__(self)
        self.manga_container = manga_container

    def get_runnable(self):
        return _RequestMangaCoverTaskRunnable(self)


class _RequestMangaCoverTaskRunnable(BaseTaskRunnable):

    def execute(self):
        manga_container = self.task.manga_container
        module = manga_container.module

        if not manga_container.cover:
            return

        content_dir = Utils.get_content_folder()
        output_dir = os.path.join(content_dir, module.get_module_id(), manga_container.m_id)
        output_filename = os.path.join(output_dir, "cover")

        if not os.path.exists(output_filename) or not os.path.isfile(output_filename):
            Utils.create_dir_if_not_exist(output_dir)
            dl = _download(manga_container.cover)
            if not dl:
                manga_container.cover = None
                return
            image_data = bytearray(dl)

            with open(output_filename, "w+b") as fs:
                fs.write(bytearray(image_data))
        elif manga_container.cover_local is None or manga_container.cover_local_data is None:
            manga_container.cover_local = output_filename
            manga_container.cover_local_data = QIcon(output_filename)

        self.task.results = output_filename




