import json
import os
from decimal import Decimal

from calibre_plugins.manga.manga_api.chapter_container import ChapterContainer
from calibre_plugins.manga.thread_task.base_task import BaseTask, BaseTaskRunnable
from calibre_plugins.manga.utils import Utils

try:
    from calibre_plugins.manga.manga_api import mangarock
except ImportError:
    from calibre_plugins.manga.manga_api import mangarock_API


class RequestDownloadedChapterListTask(BaseTask):

    _parallel_limit = 0

    def get_runnable(self):
        return _RequestDownloadedChapterListTaskRunnable(self)


class _RequestDownloadedChapterListTaskRunnable(BaseTaskRunnable):

    def execute(self):
        metadata_files = []
        for root, dir, files in os.walk(Utils.get_content_folder()):
            for f in files:
                if f.endswith("metadata.json"):
                    path = os.path.join(root, f)
                    metadata_files.append(path)
        #             print(path)
        # print(len(metadata_files))
        chapters = []
        for metafile in metadata_files:
            chapters.append(self.parse_metafile_to_chapter(metafile))

        self.task.results = chapters
        pass

    def parse_metafile_to_chapter(self, metafile):
        with open(metafile, "r") as f:
            data = json.loads(f.read())

        chapter = ChapterContainer(None, data["c_id"])
        chapter.name = data["name"]
        chapter.last_updated = data["last_updated"]
        chapter.c_number = Decimal(data["c_number"])
        return chapter

