from calibre_plugins.manga.thread_task.base_task import BaseTask, BaseTaskRunnable
from calibre_plugins.manga.thread_task.parallel_task import ParallelTask
from calibre_plugins.manga.thread_task.request_chapter_content_task import RequestChapterContentTask

try:
    from calibre_plugins.manga.manga_api import mangarock
except ImportError:
    from calibre_plugins.manga.manga_api import mangarock_API


class RequestChapterListTask(BaseTask):

    _parallel_limit = 0

    def __init__(self, manga_container):
        BaseTask.__init__(self)
        self.manga_container = manga_container

    def get_runnable(self):
        return _RequestChapterLIstTaskRunnable(self)

    def on_parallel_complete(self, task, results):
        # print("complete:{}".format(self))
        # self.results = results
        self.emit_completed()


class _RequestChapterLIstTaskRunnable(BaseTaskRunnable):

    def execute(self):
        manga = self.task.manga_container
        self.task.results = manga.module.get_chapter_list(manga)
        parallel_task = ParallelTask()
        parallel_task.on_completed.connect(self.task.on_parallel_complete)
        for chapter in self.task.results:
            request_task = RequestChapterContentTask(chapter, False)
            parallel_task.add_task(request_task)

        parallel_task.start()

    def on_completed(self):
        pass


