import time

from PyQt5 import QtCore
from PyQt5.QtCore import QThread

from calibre_plugins.manga.thread_task.base_task import BaseTask, BaseTaskRunnable
mutex = QtCore.QMutex()


class ParallelTask(BaseTask):

    def __init__(self, tasks=[]):
        BaseTask.__init__(self)
        self.tasks = list(tasks)
        self._error_thrown = False
        self.progress_tracker_list = []

    def add_task(self, task):
        self.tasks.append(task)

    def get_runnable(self):
        return _ParallelTaskRunnable(self)

    def on_task_error(self, task, error_message):
        if not self._error_thrown:
            self._error_thrown = True
            for t in self.tasks:
                t.stop()

            self.on_error.emit(task, error_message)

    # def on_task_complete(self, task, results):
    #     for i, t in enumerate(self.tasks):
    #         if task == t:
    #             self.results[i] = results
    #             break

    def on_parallel_task_update(self, task, current, total):
        # print current, total
        if current == total:
            for index, t in enumerate(self.tasks):
                if t == task:
                    self.results[index] = task.get_results()
                    break

        # print self.tasks
        # print len(self.tasks)
        for index, t in enumerate(self.tasks):
            if t == task:
                self.progress_tracker_list[index] = t.get_progress()
                break

        progress = 0
        total = 0
        # print "{}".format(self.progress_tracker_list)
        for p in self.progress_tracker_list:
            progress += p[0]
            total += p[1]
            # print(p)

        self.set_progress_total(total)
        self.update_progress(progress)

        if (self._current_progress_index == self._number_of_progress) and \
                not self._error_thrown and \
                not self._is_completed:
            # print "{}-{}/{}".format(len(self.tasks), self._current_progress_index, self._number_of_progress)
            # print self.tasks
            # self._is_running = False
            # self._is_completed = True
            # print time.time(), "emit", self.objectName()
            # print self.thread().objectName
            self.emit_completed()


class _ParallelTaskRunnable(BaseTaskRunnable):

    def on_completed(self):
        pass

    def execute(self):
        # print "len:{}".format(len(self.task.tasks))
        mutex.lock()
        self.task.set_progress_total(len(self.task.tasks))
        mutex.unlock()

        self.task.results = []
        for i in range(len(self.task.tasks)):
            self.task.progress_tracker_list.append((0, 1,))
            self.task.results.append(None)
        # print "list:{}".format(len(self.task.progress_tracker_list))
        for task in self.task.tasks:
            task.on_error.connect(self.task.on_task_error)
            # task.on_completed.connect(self.task.on_task_complete)
            task.on_process_update.connect(self.task.on_parallel_task_update)
            task.start()

        # self.task.on_parallel_task_update(None, *self.task.get_progress())



