from PyQt5.QtCore import QObject, pyqtSignal

from calibre_plugins.manga.manga_api.chapter_container import ChapterContainer


class DownloadManager(QObject):
    __instance = None

    on_chapter_complete = pyqtSignal(object)

    @staticmethod
    def get_instance():
        if DownloadManager.__instance is None:
            DownloadManager()
        return DownloadManager.__instance

    def __init__(self):
        if DownloadManager.__instance is not None:
            raise Exception("This class is a singleton!")
        super(DownloadManager, self).__init__()
        DownloadManager.__instance = self

    @staticmethod
    def register_chapter_complete_slot(method):
        # type: (Callable[[ChapterContainer], None]) -> None
        DownloadManager.get_instance().on_chapter_complete.connect(method)

    @staticmethod
    def unregister_chapter_complete_slot(method):
        # type: (Callable[[ChapterContainer], None]) -> None
        DownloadManager.get_instance().on_chapter_complete.disconnect(method)

    @staticmethod
    def emit_chapter_complete_event(chapter):
        # type: (ChapterContainer) -> None
        # DownloadManager.get_instance().on_chapter_complete.emit(chapter)
        pass

