from PyQt5 import QtCore

from calibre_plugins.manga.thread_task.base_task import BaseTask, BaseTaskRunnable
from calibre_plugins.manga.utils import BuildFormats, Utils

mutex = QtCore.QMutex()

from calibre_plugins.manga.manga_api.chapter_container import ChapterContainer

try:
    from calibre_plugins.manga.manga_api import mangarock
except ImportError:
    from calibre_plugins.manga.manga_api import mangarock_API


class BuildVolumeTask(BaseTask):

    def __init__(self, chapter_containers, filename=None, build_format=BuildFormats.CBZ):
        # type: (List[ChapterContainer], BuildFormats.CBZ) -> None
        BaseTask.__init__(self,)
        self.chapter_containers = chapter_containers
        self.filename = filename
        self.build_format = build_format

    def get_runnable(self):
        return _BuildVolumeTaskRunnable(self)


def order(chapter):
    return chapter.c_number


class _BuildVolumeTaskRunnable(BaseTaskRunnable):

    def execute(self):
        content_folder = Utils.get_content_folder()
        mutex.lock()
        chapter_list = list(self.task.chapter_containers)
        mutex.unlock()
        # print "chapter", len(chapter_list)
        # print "pages:", chapter_list[0].pages
        chapter_list.sort(key=order, reverse=False)

        builder = BuildFormats.get_build_function(self.task.build_format)
        path = builder(chapter_list, filename=self.task.filename, location=content_folder)
        self.task.results = path
        # print "complete build"



