import json
import re

from calibre_plugins.manga.manga_api.chapter_container import ChapterContainer
from calibre_plugins.manga.manga_api.manga_container import MangaContainer

try:
    from urllib2 import urlopen, Request
except:
    from urllib.request import urlopen, Request


def _get_url_data(url):
    req = Request(url)
    req.add_header("Host", "fanfox.net")
    req.add_header("User-Agent", "")
    req.add_header("Referer", url)
    req.add_header("Cache-Control", "no-cache")
    return urlopen(req).read()


def _get_page_list(c_id, internal_c_id, page_start_index=1):
    url = "http://fanfox.net/manga/chapterfun.ashx?cid={}&page={}".format(internal_c_id, page_start_index)
    req = Request(url)
    req.add_header("Host", "fanfox.net")
    req.add_header("User-Agent", "")
    req.add_header("Referer", "http://fanfox.net/manga/naruto/c{}/".format(c_id))
    req.add_header("Cookie", "image_time_cookie={}|0|0".format(internal_c_id))
    req.add_header("Cache-Control", "no-cache")
    response = urlopen(req).read()

    t = re.findall(r'\}\(.*{}\)', response)[0]
    t = "[{}]".format(t[2:-1])

    def swap_quotes(s):
        s = s.replace("\"", "'")
        return "\"{}\"".format(s[1:-1])

    t = re.sub('\'.*?\'', lambda x: swap_quotes(x.group()), t)

    def split(s):
        return ",{}".format(json.dumps(s[1:-1].split('|')))

    t = re.sub(r'(?:\,)(\".*\")(?:\.split\(\"\|\"\))', lambda x: split(x.group(1)), t)

    param_list = json.loads(t)
    js = parse(*param_list)

    url_base = re.findall(r'(?:(pix=))\'(.*?)\'', js)[0][1]
    url_page_list = re.findall(r'(?:(pvalue=))(\[.*?\])', js)[0][1]
    url_page_list = json.loads(url_page_list.replace("'", "\""))
    for i, url in enumerate(url_page_list):
        url_page_list[i] = "http:{}{}".format(url_base, url)

    return url_page_list


def get_page_list(chapter_container):
    m_id = chapter_container.manga_container.m_id
    c_id = chapter_container.c_id
    url = "http://fanfox.net/manga/{}/c{}/1.html".format(m_id, c_id)
    data = _get_url_data(url)
    internal_c_id = int(re.search(r'(?:var\ chapterid\ =)(\d*)', data).group(1))

    page_list_1 = _get_page_list(c_id, internal_c_id)
    if len(page_list_1) > 1:
        page_list_2 = _get_page_list(c_id, internal_c_id, 2)
        for i in page_list_2:
            if i not in page_list_1:
                page_list_1.append(i)
        page_list_1.remove(page_list_1[-1])

    return page_list_1


def base36encode(number, alphabet='0123456789abcdefghijklmnopqrstuvwxyz'):
    """Converts an integer to a base36 string."""
    if not isinstance(number, (int, long)):
        raise TypeError('number must be an integer')

    base36 = ''
    sign = ''

    if number < 0:
        sign = '-'
        number = -number

    if 0 <= number < len(alphabet):
        return sign + alphabet[number]

    while number != 0:
        number, i = divmod(number, len(alphabet))
        base36 = alphabet[i] + base36

    return sign + base36


def parse(p, a, c, k, e, d):

    def e(c):
        part1 = ""
        if c < a:
            part1 = ""
        else:
            part1 = e(int(c / a))
        part2 = ""
        c = c % a
        if c > 35:
            part2 = chr(c + 29)
        else:
            part2 = base36encode(c)

        return "{}{}".format(part1, part2)

    while c:
        c = c - 1
        d[e(c)] = k[c] or e(c)

    def k1(e):
        if e == '':
            return ''
        return d[e]

    k = [k1]

    def e1():
        return '\\w+'
    c = 1

    while not c == 0:
        c = c - 1
        if k[c]:
            p = re.sub(r'[\w]*', lambda x: k[c](x.group()), p)

    return p


manga = MangaContainer(None, "one_piece")
chapter = ChapterContainer(manga, 101)
print get_page_list(chapter)
