from PyQt5.Qt import QAbstractItemModel
from PyQt5 import Qt, QtCore

import os

from PyQt5.QtCore import QModelIndex

from calibre_plugins.manga.model.abstract_list_model import AbstractListModel
from calibre_plugins.manga.thread_task.request_manga_cover_task import RequestMangaCoverTask
from calibre_plugins.manga.thread_task.task_manager import TaskManager

mutex = QtCore.QMutex()

DISPLAY_SUB_TITLE_ROLE = 100


class MangaListModel(AbstractListModel):

    def __init__(self):
        super(MangaListModel, self).__init__()
        self.on_add_item.connect(self.on_add_item_method)

    def on_add_item_method(self, data):
        # task = RequestMangaCoverTask(data)
        # task.on_completed.connect(self.on_task_complete)
        # task.start()
        pass

    def on_task_complete(self, task):
        # print(task.manga_container.name)
        self.dataChanged.emit(QModelIndex(), QModelIndex())

    def data(self, index, role):
        # type: (MangaListModel, QModelIndex, int) -> None
        manga = self._data[index.row()]
        if role == QtCore.Qt.CheckStateRole:
            return QtCore.QVariant()

        if role == DISPLAY_SUB_TITLE_ROLE and len(manga.authors) > 0:
            return QtCore.QVariant(manga.authors[0])

        if role == QtCore.Qt.DecorationRole:
            cover_image = manga.cover_local_data
            if cover_image is not None:
                return QtCore.QVariant(cover_image)

            request_task = RequestMangaCoverTask(manga)
            similar_task = TaskManager.find_similar_task(request_task)
            if similar_task is None:
                # print("request:{}".format(manga.name))
                request_task.on_completed.connect(self.on_task_complete)
                request_task.start()

            return QtCore.QVariant()

        if role == QtCore.Qt.DisplayRole:
            return QtCore.QVariant(self._data[index.row()].name)

        return QtCore.QVariant()
