from datetime import datetime

from PyQt5 import QtCore

from calibre_plugins.manga.model.abstract_list_model import AbstractListModel
from calibre_plugins.manga.thread_task.request_chapter_content_task import RequestChapterContentTask
from calibre_plugins.manga.thread_task.task_manager import TaskManager

mutex = QtCore.QMutex()

DISPLAY_SUB_TITLE_ROLE = 100
DISPLAY_DOWNLOAD_PROGRESS = 101
URL_ROLE = 102

class ChapterListModel(AbstractListModel):

    def get_chapter(self, index):
        return self._data[index.row()]

    def data(self, index, role):
        chapter = self.get_chapter(index)

        if role == QtCore.Qt.CheckStateRole:
            return QtCore.QVariant()

        if (role == DISPLAY_SUB_TITLE_ROLE) and (chapter.last_updated != -1):
            date_string = datetime.fromtimestamp(chapter.last_updated).strftime('%Y-%m-%d')
            return QtCore.QVariant(date_string)

        if role == QtCore.Qt.DisplayRole:
            return QtCore.QVariant(self._data[index.row()].name)

        if role == DISPLAY_DOWNLOAD_PROGRESS:
            if chapter.pages is not None and len(chapter.pages) > 0:
                return QtCore.QVariant("[100%]")
            download_task = self.get_download_progress(chapter.c_id)
            if download_task is not None:
                progress = download_task.get_progress()
                return QtCore.QVariant("[{0:.0f}%]".format(float(progress[0])*100/progress[1]))

        if role == URL_ROLE:
            return QtCore.QVariant(chapter.manga_container.module.get_chapter_url(chapter))

        return QtCore.QVariant()

    def get_download_progress(self, c_id):
        # mutex.lock()
        running_task_list = list(TaskManager.get_instance().get_running_tasks())
        download_chapter_list = filter(lambda x: isinstance(x, RequestChapterContentTask), running_task_list)
        download_task = next((x for x in download_chapter_list if x.chapter_container.c_id == c_id), None)
        # mutex.unlock()
        return download_task
