from PyQt5.Qt import QAbstractItemModel
from PyQt5 import Qt, QtCore

import os

from PyQt5.QtCore import QModelIndex, pyqtSignal
from PyQt5.QtWidgets import QWidget

DISPLAY_SUB_TITLE_ROLE = 100


class AbstractListModel(QAbstractItemModel):

    on_add_item = pyqtSignal(object)

    def __init__(self, data=[], parent=None):
        super(AbstractListModel, self).__init__(parent)
        self._data = data

    def rowCount(self, *arg):
        return len(self._data)

    def columnCount(self, *arg):
        return 1

    def clear(self):
        self.beginInsertRows(QModelIndex(), self.rowCount(), self.rowCount())
        self._data = []
        self.endInsertRows()

    def add(self, item):
        index_start = self.createIndex(self.rowCount(), 0)
        index_end = self.createIndex(self.rowCount()+1, 0)
        self.beginInsertRows(index_start, self.rowCount(), self.rowCount())
        self._data.append(item)
        self.endInsertRows()
        self.on_add_item.emit(item)

    def get_data_at(self, index):
        return self._data[index]

    def data(self, index, role):
        return QAbstractItemModel.data(index, role)

    def index(self, row, column, parent):
        return self.createIndex(row, column)

    def parent(self, index):
        item = index.internalPointer()
        if item:
            return item.getParent()
        else:
            item = self.createIndex(index.row(), index.column()).internalPointer()
            if item:
                return item.getParent()

        return QtCore.QModelIndex()
