import unittest
from calibre_plugins.manga.manga_api.manga_container import MangaContainer
from calibre_plugins.manga.manga_api.mangarock_API import MangarockAPI

mangarock = MangarockAPI()


class TestMangaRock(unittest.TestCase):

    def test_manga_details(self):
        manga_list = mangarock.get_manga_list(["mrs-serie-173467"])

        self.assertIs(type(manga_list), type([]))
        self.assertGreater(len(manga_list), 0)

        self.assertTrue(manga_list[0].name == "Naruto")

    def test_quick_search(self):
        manga_list = mangarock.get_quick_search('naruto')

        self.assertGreater(manga_list, 0)

    def test_quick_search_with_details(self):
        manga_list = mangarock.get_quick_search('naruto')

        self.assertIs(type(manga_list), type([]), "Isn't returning an array! Instead: {}".format(type(manga_list)))

    def test_chapter_lists(self):
        chapter_list = mangarock.get_chapter_list(MangaContainer(mangarock, "mrs-serie-173467"))

        self.assertIs(type(chapter_list), type([]))
        self.assertGreater(len(chapter_list), 0)


if __name__ == '__main__':
    unittest.main()
