from calibre_plugins.manga.manga_api.mangahere_API import MangahereAPI
from calibre_plugins.manga.manga_api.mangarock_API import MangarockAPI
from calibre_plugins.manga.manga_api.mangafox_API_v2 import MangafoxAPI


class ModuleManager:
    __instance = None

    @staticmethod
    def getInstance():
        if ModuleManager.__instance is None:
            ModuleManager()
        return ModuleManager.__instance

    def __init__(self):
        if ModuleManager.__instance is not None:
            raise Exception("This class is a singleton!")
        ModuleManager.__instance = self
        self.module_list = []
        self.module_list.append(MangarockAPI())
        self.module_list.append(MangafoxAPI())
        self.module_list.append(MangahereAPI())

    @staticmethod
    def get_module_list():
        return ModuleManager.getInstance().module_list
