from calibre_plugins.manga.manga_api.api_module import APIModule

try:
    from urllib2 import urlopen, Request
except:
    from urllib.request import urlopen, Request

import json


from .chapter_container import ChapterContainer
from .manga_container import MangaContainer

country = ""
query_version = 401


class MangarockAPI(APIModule):

    def get_module_id(self):  # type: () -> AnyStr
        return "mangarock.com"

    def get_host(self):
        return "mangarock.com"

    def get_base_url(self):
        return "http://mangarock.com"

    def _get_quick_search_without_details(self, search_string):
        if len(search_string) < 3:
            return []

        url = "https://api.mangarockhd.com/query/web{0}/mrs_search".format(query_version)
        data = {"type": "series", "keywords": "{0}".format(search_string)}

        req = Request(url)
        req.add_header('Content-Type', 'application/json')
        response = urlopen(req, bytearray(json.dumps(data), encoding='utf8'))

        raw = json.loads(response.read())
        search_result_data = raw["data"]

        return search_result_data

    def get_quick_search(self, search_string):
        if len(search_string) >= 3:
            search_results = self._get_quick_search_without_details(search_string)
            series_details = self.get_manga_list(search_results)
            return series_details

        return []

    # def get_manga_list(self):
    #     url = "https://api.mangarockhd.com/query/web{0}/mrs_filter".format(query_version)
    #     data = {"status": "all", "genres": {}, "rank": "all", "order": "rank"}
    #
    #     req = Request(url)
    #     req.add_header('Content-Type', 'application/json')
    #     response = urlopen(req, json.dumps(data))
    #
    #     return json.loads(response.read())["data"]

    def get_manga_list(self, manga_ids):
        # type: (List[string]) -> List[MangaContainer]
        if len(manga_ids) == 0:
            return []

        url = "https://api.mangarockhd.com/query/web{0}/manga_detail".format(query_version)
        data = {"oids": {}}

        for index, oid in enumerate(manga_ids):
            data["oids"][oid] = index

        data["sections"] = ["basic_info", "summary"]

        req = Request(url)
        req.add_header('Content-Type', 'application/json')
        response = urlopen(req, bytearray(json.dumps(data), encoding='utf8'))

        raw = json.loads(response.read())
        data = raw["data"]
        results = []

        for m_id in manga_ids:
            data_oid = data[m_id]
            data_oid_default = data_oid["default"]
            data_oid_basicinfo = data_oid["basic_info"]

            manga = MangaContainer(self, m_id)
            manga.name = data_oid_basicinfo["name"]
            manga.banner = data_oid_basicinfo["cover"]
            manga.cover = data_oid_basicinfo["thumbnail"]
            manga.last_update = data_oid_default["last_updated"]
            manga.authors = [data_oid_basicinfo["author"]]
            manga.description = data_oid_basicinfo["description"]

            results.append(manga)

        return results

    def get_chapter_list(self, manga_container):
        # type: (MangaContainer) -> List[ChapterContainer]

        url = "https://api.mangarockhd.com/query/web{0}/manga_detail".format(query_version)
        data = {"oids": {"{0}".format(manga_container.m_id): 0}, "sections": ["chapters"]}

        req = Request(url)
        req.add_header('Content-Type', 'application/json')
        response = urlopen(req, bytearray(json.dumps(data), encoding='utf8'))

        raw_json = json.loads(response.read())
        data = raw_json["data"][manga_container.m_id]
        data_chapters = data["chapters"]["chapters"]
        results = []
        for data_chapter in data_chapters:
            chapter = ChapterContainer(manga_container, data_chapter["oid"])
            chapter.name = data_chapter["name"]
            chapter.last_updated = data_chapter["last_updated"]
            chapter.c_number = data_chapter["order"]

            results.append(chapter)

        manga_container.chapters = results

        return results

    def get_chapter_url(self, chapter_container):
        return "{}/manga/{}/chapter/{}".format(self.get_base_url(),
                                               chapter_container.manga_container.m_id,
                                               chapter_container.c_id)

    def get_page_list(self, chapter_container):
        url = "https://api.mangarockhd.com/query/web{0}/pages?oid={1}".format(query_version, chapter_container.c_id)

        req = Request(url)
        response = urlopen(req)

        return json.loads(response.read())["data"]
