from abc import abstractmethod

from calibre_plugins.manga.manga_api.chapter_container import ChapterContainer


class APIModule(object):

    def __init__(self):
        pass

    @abstractmethod
    def get_module_id(self):
        # type: () -> AnyStr
        pass

    @abstractmethod
    def get_host(self):
        # type: () -> AnyStr
        pass

    @abstractmethod
    def get_base_url(self):
        # type: () -> AnyStr
        pass

    @abstractmethod
    def get_quick_search(self, search_string):
        # type: (string) -> List[MangaContainer]
        pass

    @abstractmethod
    def get_manga(self, m_id):
        # type: (string) -> MangaContainer
        pass

    @abstractmethod
    def get_manga_list(self, m_ids):
        # type: (List[string]) -> List[MangaContainer]
        pass

    @abstractmethod
    def get_chapter_list(self, manga_container):
        # type: (MangaContainer) -> List[ChapterContainer]
        pass

    @abstractmethod
    def get_chapter_url(self, chapter_container):
        # type: (ChapterContainer) -> AnyStr
        pass

    @abstractmethod
    def get_page_list(self, chapter_container):
        # type: (ChapterContainer) -> List[AnyStr]
        pass
