from __future__ import absolute_import, division, print_function, unicode_literals

from calibre.customize import InterfaceActionBase

class InterfaceMangaPlugin(InterfaceActionBase):

    name                = 'Manga'
    description         = 'Manga finder plugin'
    supported_platforms = ['windows', 'osx', 'linux']
    author              = ''
    version             = (0, 1, 0)
    minimum_calibre_version = (4, 0, 0)

    actual_plugin       = 'calibre_plugins.manga.ui:InterfacePlugin'

    def is_customizable(self):
        return True

    def config_widget(self):
        from calibre_plugins.manga.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):
        config_widget.save_settings()

        # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()


