#!/bin/sh

#####
# Copyright (c) 2019 Y Paritcher
#####

# runs when the system displays the screensaver
do_ScreenSaver()
{
	logger -t "wakescript[$$]" -p local4.info "I display screensaver"
}

# runs when the RTC wakes the system up
wake_up_rtc()
{
	logger -t "wakescript[$$]" -p local4.info "I wakeup alarm RTC"
}

# runs when the system wakes up
# this can be for many reasons (rtc, power button)
wake_up()
{
	logger -t "wakescript[$$]" -p local4.info "I wakeup alarm"
	POWERD_STATES=`lipc-get-prop -s com.lab126.powerd state`
	logger -t "wakescript[$$]" -p local4.info "I PowerD state: $POWERD_STATES"
	if [ "$POWERD_STATES" == "screenSaver" ] || [ "POWERD_STATES" == "suspended" ] ; then
	  wake_up_rtc
	fi
}

# runs when in the readyToSuspend state;
# sets the rtc to wake up 
# delta = amount of seconds to wake up in
ready_suspend()
{
	delta="120"
	lipc-set-prop -i com.lab126.powerd rtcWakeup $delta
	logger -t "wakescript[$$]" -p local4.info "I delta: $delta"
}

# main loop, waits for powerd events
lipc-wait-event -m com.lab126.powerd goingToScreenSaver,wakeupFromSuspend,readyToSuspend | while read event; do
	case "$event" in
		goingToScreenSaver*)
			do_ScreenSaver;;
		wakeupFromSuspend*)
			wake_up;;
		readyToSuspend*)
			ready_suspend;;
	esac
done;
