#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Based on Rubeus and Doitsu ideas
#https://www.mobileread.com/forums/showthread.php?t=259980

from PIL import ImageFont
from io import BytesIO
import os
import re

# main routine
def run(bk):
    used_fonts = []
    report = ''

    for (id, href, mime) in bk.font_iter():
        # get all fonts from the manifest
        lohref = href.lower()
        if lohref.endswith('tf'):
            font_object = ImageFont.truetype(BytesIO(bk.readfile(id)))
            used_fonts.append(font_object.font.family)
            s_attr     = 'normal'
            w_attr     = 'normal'

            font_style = font_object.font.style.upper()

            if 'ITALIC' in font_style or 'OBLIQUE' in font_style:
                s_attr = 'italic'

            if 'BOLD' in font_style:
                w_attr = 'bold'

            if 'THIN' in font_style:
                w_attr = '100'

            if 'EXTRALIGHT' in font_style or 'ULTRALIGHT' in font_style:
                w_attr = '200'

            if 'LIGHT' in font_style:
                w_attr = '300'

            if 'NORMAL' in font_style or 'REGULAR' in font_style:
                w_attr = 'normal'

            if 'MEDIUM' in font_style:
                w_attr = '500'

            if 'DEMIBOLD' in font_style or 'SEMIBOLD' in font_style:
                w_attr = '600'

            if 'EXTRABOLD' in font_style or 'ULTRABOLD' in font_style:
                w_attr = '800'

            if 'BLACK' in font_style or 'HEAVY' in font_style:
                w_attr = '900'

            if 'EXTRABLACK' in font_style or 'ULTRABLACK' in font_style:
                w_attr = '950'

            report += '\n'
            report += '  File:   ' + os.path.basename(href) + '\n'
            report += '  Family: ' + font_object.font.family + '\n'
            report += '  Style:  ' + font_object.font.style + '\n'

    used_fonts = list(set(used_fonts))
    used_fonts.sort()

    print(report)

    print('\nDone.\n\nPlease click OK to close the Plugin Runner window.')
    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
