import os
import re
import string
from string import Template
import time

"""
Config Section
"""
libxml = "books.xml"
webserver_url ="http://mysite.com/ebooks/"
calibre_dir = "C:\\Progra~1\\calibre\\"
library_title = "My Library"
librarian_name = "Me"
librarian_email = "librarian@mysite.com"
"""
End of config section
"""

separator="XXX"
cmdline_tool = "calibredb.exe"
option1 = " list"
option2 = " --fields=title,authors,series,series_index,tags,path,size,timestamp"
option3 = " --separator="+separator
option4 = " --line-width=2000"
libdir = ""

index_i = 0
title_i = 1
authors_i = 2
series_i = 3
series_index_i = 4
tags_i = 5
path_i = 6
size_i = 7
timestamp_i = 8

totalbooks = 0
epubs = 0

library = dict()

def generate_id( path, date ):
    id_tag = webserver_url
    id_tag = id_tag.replace('http://','')
    id_tag = id_tag.replace('/',','+date+'/',1)
    id_tag = "tag:"+id_tag+path
    return id_tag

# Clean Spaces from Vars used in URL's
webserver_url.replace(' ', '%20')
libxml.replace(' ', '%20')

feed_template = '<feed xmlns="http://www.w3.org/2005/Atom" xmlns:dc="http://purl.org/dc/elements/1.1/">\n \
  <title>$LIBRARY_TITLE</title>\n \
  <id>$LIBRARY_ID</id>\n \
  <updated>$LIBRARY_UPDATED</updated>\n \
  <link rel="self" type="application/atom+xml" href="$PATH_URL"/>\n \
  <author>\n \
    <name>$LIBRARIAN</name>\n \
    <uri>$WEBSERVER_URL</uri>\n \
    <email>$LIBRARIAN_EMAIL</email>\n \
  </author>\n \
$ENTRIES \
</feed>\n \
'

entry_template = '\n<entry>\n \
    <title>$TITLE</title>\n \
    <content type="xhtml">\n \
      <div xmlns="http://www.w3.org/1999/xhtml" align="center">$INFO</div>\n \
    </content>\n \
    <id>$ID</id>\n \
    <author>\n \
      <name>$AUTHOR</name>\n \
    </author>\n \
    <updated>$UPDATED</updated>\n \
    <link type="application/epub+zip" href="$BOOK_LINK"/>\n \
    <link rel="x-stanza-cover-image-thumbnail" type="image/jpg" href="$COVER_LINK"/>\n \
    <link rel="x-stanza-cover-image" type="image/jpg" href="$COVER_LINK"/>\n \
</entry> \
'

"""
Create a data structure containing all of the required info on the Ebooks
"""
file = os.popen(calibre_dir+cmdline_tool+option1+option2+option3+option4, 'r')
i = 1
while 1:
    line = file.readline()
    if not line:
        break
    if i == 1:
        libdir = line.replace('Using library at ','')
        libdir = libdir.strip()
    elif i > 2:
        totalbooks = totalbooks + 1
        bookinfo = line.split('XXX')
        bookinfo = map(string.strip,bookinfo)
        junk = bookinfo.pop()
        if string.find(bookinfo[path_i], 'epub') != -1:
            print bookinfo[title_i]+"\t"+bookinfo[authors_i]+"\t"+bookinfo[series_i]+" "+bookinfo[series_index_i]
            epubs = epubs + 1
            p = re.compile('(\[epub,zip\]|\[zip\]|\[epub\])')
            bookinfo[path_i] = p.sub('epub',bookinfo[path_i])
            bookinfo[path_i] = bookinfo[path_i].replace('\\','/')
            bookinfo[path_i] = bookinfo[path_i].replace(' ', '%20')
            bookinfo[timestamp_i] = bookinfo[timestamp_i].replace(' ','T')
            library[bookinfo[index_i]] = bookinfo
        else:
            print "** ",bookinfo[title_i]," is not an epub"
    i = i + 1
status = file.close()
if status:
    status = status >> 8
    print my_command, 'exited with abnormal status', status
    
print "\nFound",epubs, "Epub books in",i-3,"library items"

"""
Create the Stanza atom feed file using the templates and gathered info
"""
date = time.strftime("%Y-%m-%dT%H:%M:%S-00:00", time.localtime())
allbooks = ""

# Loop through dictionary containing book info and populate entry template
for key, book in library.iteritems():
    bookfeed = Template(entry_template)
    info = ""
    if string.find(book[tags_i], 'None') == -1:
        info=info+"Subject: "+book[tags_i]+"<br />"
    if string.find(book[series_i], 'None') == -1:
        info=info+"Series: "+book[series_i]+" "+book[series_index_i]+"<br />"
    info=info+"Size: "+book[size_i]+" bytes<br />"    
    p = re.compile('^.*/')
    cover_match = p.match(book[path_i])
    cover_path = cover_match.group()+"cover.jpg"
    p = re.compile('T.*$')
    updated = p.sub('',book[timestamp_i])+":"
    book = bookfeed.substitute(TITLE=book[title_i], 
                           INFO=info, 
                           ID=generate_id(book[path_i],updated), 
                           AUTHOR=book[authors_i], 
                           UPDATED=book[timestamp_i]+"+00:00",
                           BOOK_LINK=webserver_url+book[path_i], 
                           COVER_LINK=webserver_url+cover_path)
    allbooks = allbooks+book

stanzafeed = Template(feed_template)
feed_id = generate_id(libxml,time.strftime("%Y-%m-%d:", time.localtime()))
feed = stanzafeed.substitute(LIBRARY_TITLE=library_title,
                      LIBRARY_ID=feed_id,
                      LIBRARY_UPDATED=date,
                      PATH_URL=webserver_url+libxml,
                      LIBRARIAN=librarian_name,
                      WEBSERVER_URL=webserver_url,
                      LIBRARIAN_EMAIL=librarian_email,
                      ENTRIES=allbooks)
outfile = libdir+'\\'+libxml
print "writing to "+outfile+"\n"
f=open(outfile, 'w')
f.write(feed)
f.close()