#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
from sigil_bs4 import BeautifulSoup
from sigil_bs4.builder._lxml import LXMLTreeBuilderForXML


def run(bk):
    xmlbuilder = LXMLTreeBuilderForXML(parser=None)
    metadata = bk.getmetadataxml()
    print(metadata)
    metadata_soup = BeautifulSoup(metadata, features=None, from_encoding="utf-8", builder=xmlbuilder)
    print(metadata_soup)
    dc_language = metadata_soup.find('dc:language')
    if not dc_language:
        dc_language = metadata_soup.new_tag('dc:language')
        metadata_soup.metadata.append(dc_language)
    dc_language.string = 'en-US'
    new_metadata = metadata_soup.decodexml(indent_level=0, formatter='minimal', indent_chars="  ")
    print(new_metadata)
    
    bk.setmetadataxml(new_metadata)
    print('Done')
    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())