#!/bin/sh
#outline.sh:
#2019-06-29 v0.2 additional styles: Squashed and Spread 
# Use overlay with margin displacement to create an formatting effects
#expects PATH=$PATH:.:..
cd /mnt/us

tt=regular=/mnt/us/fonts/poplarstd.otf

#keep the Kindle quiet
lipc-set-prop com.lab126.powerd preventScreenSaver 1
killall -stop cvm # pause framework

#WATERMARK ghostly text artifacts leftovers from AA, blending, or other
fbink -t $tt,size=86 "GHOST" -o -M -m -c
fbink -t $tt,size=86 "GHOST" -o -M -m 
screenshot #save for posting

#OUTLINE text
fbink -t $tt,size=86 "OUTLINE" -o -M -m -c
fbink -t $tt,size=86,top=2,left=2 "OUTLINE" -o -M -m
screenshot #save for posting

#3D text
fbink -c ''
i=0
while [ $i -le 40 ]; do
  fbink -t $tt,size=76 "3 D" -M -m -o
  fbink -t $tt,size=76,top="$i",left="$i" "3 D" -M -m -o
  i=$(($i + 4))
done
screenshot #save for posting

#ZOOMED text
fbink -t $tt,size=126 "ZOOM" -M -m -o -c
i=118
while [ $i -ge 8 ]; do
  fbink -t $tt,size=$i "ZOOM" -M -m -o
  fbink -t $tt,size=$i,left=3 "ZOOM" -M -m -o
  i=$(($i - 8))
done
screenshot #save for posting

#PROJECTED text
fbink -c ''
i=8
while [ $i -le 200 ]; do
  fbink -t $tt,size=$i,left=$i "O" -M --bgless
  fbink -t $tt,size=$i,left=$(($i + 2)) "O" -M -o
  i=$(($i + 8))
done  
fbink -t $tt,size=$i,left=$(($i + 2)) "O" -M - -o
screenshot #save for posting

#EMBOSSED text
fbink -t $tt,size=66,top=8,left=8 "EMBOSSED" -M -m -C GRAYC -c
fbink -t $tt,size=66,top=0,left=0 "EMBOSSED" -M -m -o
fbink -t $tt,size=66,top=2,left=2 "EMBOSSED" -M -m -o
screenshot #save for posting

#even more EMBOSSED text
fbink -t $tt,size=66,top=8,left=8 "EMBOSSED" -M -m -C GRAYC -c
fbink -t $tt,size=66,top=0,left=0 "EMBOSSED" -M -m -o
fbink -t $tt,size=66,top=2,left=2 "EMBOSSED" -M -m -o
fbink -t $tt,size=66,top=0,left=4 "EMBOSSED" -M -m -o
fbink -t $tt,size=66,top=2,left=6 "EMBOSSED" -M -m -o
screenshot #save for posting

#SHADOW text
fbink -t $tt,size=76,top=0,left=0     "SHADOW" -M -m -C GRAYC --bgless -c
fbink -t $tt,size=76,top=30,left=30 "SHADOW" -M -m -C GRAYC --bgless
fbink -t $tt,size=76,top=0,left=0     "SHADOW" -M -m -o
fbink -t $tt,size=76,top=4,left=4     "SHADOW" -M -m -o
screenshot #save for posting

#SQUASHED text
fbink -c
T="SQUASHED"
i=1;x=0
while [ $i -le ${#T} ]; do
  t=$(expr substr "$T" $i 1)  #next byte of T
  fbink -t $tt,size=86,left=$x "$t" -M
  fbink -t $tt,size=86,top=3,left=$(($x + 3)) "$t" -o -M
  i=$(($i + 1));x=$(($x + 110))
done
screenshot #save for posting

#STRETCHED text
fbink -c
T="SPREAD"
i=1;x=0
while [ $i -le ${#T} ]; do
  t=$(expr substr "$T" $i 1)  #next byte of T
  fbink -t $tt,size=20,left=$x "$t" -M
  fbink -t $tt,size=20,top=3,left=$(($x + 3)) "$t" -o -M
  i=$(($i + 1));x=$(($x + 200))
done
screenshot #save for posting

#put the Kindle back into action
killall -cont cvm
lipc-set-prop com.lab126.powerd preventScreenSaver 0