(* $Id: thopdfinfo.ml 40 2008-10-19 22:29:30Z ohl $ *)
(* Copyright (C) 2008 by Thorsten Ohl <ohl@physik.uni-wuerzburg.de>

   This is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)  

let format_rectangle r =
  Printf.sprintf "{ ll_x = %g; ll_y = %g; ur_x = %g; ur_y = %g }"
    r.ThoPDF.ll_x r.ThoPDF.ll_y r.ThoPDF.ur_x r.ThoPDF.ur_y

let format_viewport vp =
  let angle = Pdfdoc.int_of_rotation vp.ThoPDF.rotation
  and mb = format_rectangle vp.ThoPDF.mediabox in
  if vp.ThoPDF.mediabox = vp.ThoPDF.cropbox then
    Printf.sprintf "media = crop = %s, rotation = %d" mb angle
  else
    let cp = format_rectangle vp.ThoPDF.cropbox in
    Printf.sprintf "media = %s, crop = %s, rotation = %d" mb cp angle
  
let _ =
  let file = ref None
  and verbose = ref false in
  let usage = "usage: thopdfinfo [-v] file" in
  Arg.parse
    [ ("-v", Arg.Unit (fun _ -> verbose := true), "verbosity") ]
    (fun s -> file := Some s)
    usage;
  Printf.printf "thopdfinfo starting up...\n";
  flush stdout;
  begin match !file with
  | None -> ()
  | Some f -> 
      begin
	Printf.printf "reading %s ...\n" f;
	flush stdout;
	let pdf = Pdfread.pdf_of_file f in
	let pages = Pdfdoc.pages_of_pagetree pdf in
	Printf.printf "%s: %d pages\n" f (List.length pages);
	flush stdout;
	let n = ref 0 in
	List.iter
	  (fun vp ->
	    incr n;
	    Printf.printf "page %4d: %s\n" !n (format_viewport vp))
	  (ThoPDF.viewports pdf)
      end
  end;
  Printf.printf "done.\n";
  flush stdout
