(* $Id: thoPDF.mli 40 2008-10-19 22:29:30Z ohl $ *)
(* Copyright (C) 2008 by Thorsten Ohl <ohl@physik.uni-wuerzburg.de>

   This is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)  

type op (* [= Pdfpages.operator] *)

val rgb : float -> float -> float -> op
val red : op

val push_graphics_state : op
val pop_graphics_state : op

val line_width : float -> op

type line_cap_style = Butt_Cap | Round_Cap | Projecting_Cap
val line_cap_style : line_cap_style -> op

type line_join_style = Miter_Join | Round_Join | Bevel_Join
val line_join_style : line_join_style -> op

val stroke_path : (float * float) list -> op list

val doc_of_pages : Pdfdoc.page list -> Pdf.pdfdoc

(* [enclose_page_with_ops pre page post] adds [pre] before and [post] after
   the content of [page].  The graphics state is pushed before and popped
   after all three parts. *)
val enclose_page_with_ops : op list -> Pdfdoc.page -> op list -> Pdfdoc.page

val float_of_pdfobject : Pdf.pdfobject -> float

type rectangle =
    { ll_x : float;
      ll_y : float;
      ur_x : float;
      ur_y : float }

type viewport =
  { (* The required /MediaBox of a page. *)
    mediabox : rectangle;
    (* The optional /CropBox of a page.
       If none is found, the required /MediaBox instead. *)
    cropbox : rectangle;
    rotation : Pdfdoc.rotation }

val viewport_of_page : Pdfdoc.page -> viewport
val viewports : Pdf.pdfdoc -> viewport list

val xy_of_point : viewport -> Scribble.point -> float * float

val ops_of_stroke : viewport -> Scribble.stroke -> op list
val ops_of_scribble : viewport -> Scribble.scribble -> op list
