(* $Id: test.ml 35 2008-10-19 14:34:00Z ohl $ *)
(* Copyright (C) 2008 by Thorsten Ohl <ohl@physik.uni-wuerzburg.de>

   This is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)  

let string_of_option = function
  | Some s -> s
  | None -> "NULL"

let string_of_anchor_option = function
  | Some a -> Metadata.anchor_to_string a
  | None -> "NULL"

let _ =
  let file = ref None
  and db_file = ref "metadata.db"
  and dump = ref false in
  let usage = "usage: ./test_md [-D] [-d db] file" in
  Arg.parse
    [ ("-d", Arg.String (fun s -> db_file := s), "database file");
      ("-D", Arg.Unit (fun _ -> dump := true), "dump the data stucture") ]
    (fun s -> file := Some s)
    usage;
  match !file with
  | Some f ->
      let scribbles = Metadata.scribbles ~db:!db_file f in
      List.iter (fun row -> 
	Printf.printf "### file = %s (%s), anchor = %s ####\n"
	  row.Metadata.file
	  (Metadata.file_type_to_string row.Metadata.file_type)
	  (string_of_anchor_option row.Metadata.start_anchor);
	if !dump then
	  Scribble.print (Scribble.parse row.Metadata.data)
	else
	  Scribble.strokes (Scribble.parse row.Metadata.data)) scribbles
  | None ->
      let annotations = Metadata.annotations ~db:!db_file () in
      List.iter (fun row -> 
	Printf.printf "file = %s has a %s\n"
	  row.Metadata.filename
	  (Metadata.annotation_type_to_string row.Metadata.annotation_type)) annotations


