(* $Id: scribble.mli 35 2008-10-19 14:34:00Z ohl $ *)
(* Copyright (C) 2008 by Thorsten Ohl <ohl@physik.uni-wuerzburg.de>

   This is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)  

type point =
    private { p_b01 : string;
	      y : int;
	      p_b04_05 : string;
	      x : int;
	      p_b08_09 : string;
	      p_b10_12 : string }

type stroke_header =
    private { s_b01 : string;
	      s_b02_03 : int;
	      s_b04_05 : string;
	      s_b06_09 : string;
	      s_b10_17 : string;
	      width : int;
	      s_b20_21 : string;
	      num_points : int;
	      s_b24 : string }

type stroke =
    private { stroke_header : stroke_header;
	      points : point list }

type header =
    private { h_b01_36 : string;
	      num_strokes : int;
	      h_b39 : string }

type scribble =
    private { header : header;
	      strokes : stroke list; }

val parse : string -> scribble
val print : scribble -> unit
val strokes : scribble -> unit
