(* $Id: metadata.mli 35 2008-10-19 14:34:00Z ohl $ *)
(* Copyright (C) 2008 by Thorsten Ohl <ohl@physik.uni-wuerzburg.de>

   This is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)  

type file_type =
  | PDF
  | Unknown_File_Type of string

type annotation_type =
  | Scribble
  | Unknown_Annotation_Type of string

val file_type_to_string : file_type -> string
val annotation_type_to_string : annotation_type -> string

type anchor =
  | PDF_Page of int
  | Unknown_Anchor of string

val anchor_to_string : anchor -> string

type annotation =
    private { filename : string;
	      annotation_type : annotation_type }

val annotations : ?db:string -> unit -> annotation list

type scribble =
    private { file : string;
	      file_type : file_type;
	      layer : string;
	      file_position : int;
	      title : string option;
	      start_anchor : anchor option;
	      end_anchor : anchor option;
	      data : string }

val scribbles : ?db:string -> string -> scribble list

