(* $Id: hex.ml 35 2008-10-19 14:34:00Z ohl $ *)
(* Copyright (C) 2008 by Thorsten Ohl <ohl@physik.uni-wuerzburg.de>

   This is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)  

let hex_of_nibble = function
  | 0 -> '0'
  | 1 -> '1'
  | 2 -> '2'
  | 3 -> '3'
  | 4 -> '4'
  | 5 -> '5'
  | 6 -> '6'
  | 7 -> '7'
  | 8 -> '8'
  | 9 -> '9'
  | 10 -> 'A'
  | 11 -> 'B'
  | 12 -> 'C'
  | 13 -> 'D'
  | 14 -> 'E'
  | 15 -> 'F'
  | n -> invalid_arg ("hex_of_nibble: " ^ string_of_int n)

let nibble_of_hex = function
  | '0' -> 0
  | '1' -> 1
  | '2' -> 2
  | '3' -> 3
  | '4' -> 4
  | '5' -> 5
  | '6' -> 6
  | '7' -> 7
  | '8' -> 8
  | '9' -> 9
  | 'A' | 'a' -> 10
  | 'B' | 'b' -> 11
  | 'C' | 'c' -> 12
  | 'D' | 'd' -> 13
  | 'E' | 'e' -> 14
  | 'F' | 'f' -> 15
  | n -> invalid_arg ("nibble_of_hex: " ^ String.make 1 n)

let hex_of_byte_at s offset n =
  s.[offset] <- hex_of_nibble (n / 16);
  s.[succ offset] <- hex_of_nibble (n mod 16);
  ()

let hex_of_byte n =
  let s = String.create 2 in
  hex_of_byte_at s 0 n;
  s

let byte_of_hex_at s offset =
  16 * nibble_of_hex s.[offset] + nibble_of_hex s.[succ offset]

let byte_of_hex s = byte_of_hex_at s 0

let to_bytes hex =
  let hex_len = String.length hex in
  if hex_len mod 2 > 0 then
    invalid_arg "bytes_of_hex: odd number of characters"
  else
    let bytes_len = hex_len / 2 in
    let bytes = String.create bytes_len in
    for i = 0 to pred bytes_len do
      bytes.[i] <- (Char.chr (byte_of_hex_at hex (2*i)))
    done;
    bytes

let of_bytes bytes =
  let bytes_len = String.length bytes in
  let hex = String.create (bytes_len * 2) in
  for i = 0 to pred bytes_len do
    hex_of_byte_at hex (2*i) (Char.code bytes.[i])
  done;
  hex
