#!/bin/bash
printf "\nKobo Boot Image Unpacker v0.1c (c) May 2019 GPLv2 by BloodRagg\n\n"
[ -r "$1" ] || { cat <<EOF
Usage: ${0##*/} [bootimage]

EOF
exit 1;}

#set -vx
bootimg=$1

grab(){ tail -c+$(($2+1)) $1 | head -c$3;}

map=(0x00000000 0x00000200 0x00000400 0x0007FFF0 0x00080BF0 0x000a0c00 0x000c0000 0x000e0000 0x000f0000 0x00100000 0x00400000 0x006FFFF0) #kobo aura hd/h2o
name=(mbr serial ubootbin hwconfig fw dtb ubootenv data1 data2 uimage initrd waveform mbr_start_p1)
magic='ffaff5ff12345678'

echo "Extracting Image"
for i in ${!name[*]};do
  [ $i -eq 0 ] && continue
#  file="${map[$j]}_${name[$j]}"
  file="${name[$j]}"
  img="$file.img"
  bin="$file.bin"
  txt="$file.txt"
  offset=$((${map[$j]}))
  size=$((${map[$i]}-${map[$j]}))
  printf "  extracting: $img (${name[$j]})\n"
  grab $bootimg $offset $size >$img
  case ${name[$j]} in
    mbr)
      sectors=$(grab $img $((0x1c6)) 4|hexdump -ve '/4 "%d"')
      sectorsize=512
      mbr_start_p1=$((sectors*sectorsize))
      [ -n "$mbr_start_p1" -o "$mbr_start_p1" -lt 512 ] || echo "warning: invalid mbr"
      map+=("$mbr_start_p1")
      fdisk -l $img > $txt
    ;;
    serial)
      sed 's,\x0.*,,' $img > $txt
    ;;
    ubootbin)
      sed '$ s,\x0*$,,' $img > $bin
    ;;
    hwconfig)
      search=$(grab $img 0 8|hexdump -ve '/4 "%x"')
      [ "$search" = "$magic" ] && {
        offset=16
        datasize=$(grab $img $((offset+15)) 1|hexdump -ve '/2 "%d"')
        headersize=16
        size=$((headersize+datasize))
        grab $img $offset $size > $bin
      } || rm $img
    ;;
    fw|dtb|waveform)
      search=$(grab $img 0 8|hexdump -ve '/4 "%x"')
      [ "$search" = "$magic" ] && {
        offset=16
        size=$(grab $img 8 4|hexdump -ve '/4 "%d"')
        grab $img $offset $size > $bin
      } || rm $img
    ;;
    ubootenv)
      offset=4
      tail -c+$((offset+1)) $img|sed '$ s,\x0*$,,'|sed 's,\x0,\n,g' > $txt
    ;;
    data*)
      cat $img|sed '$ s,\x0*$,,' > $bin
    ;;
    uimage)
      offset=0
      size=$((0x$(grab $img 12 4|hexdump -ve '4/1 "%x"'))+64)
      grab $img $offset $size > $bin
      grab $img $((offset+64)) $((size-64)) >${bin/uimage/zimage}
    ;;
    initrd) #unused afaict
      offset=0
      size=$((0xc00*2))
      grab $img $offset $size > $bin
    ;;
  esac
  j=$i
done
printf "Done.\n\n"
exit 0
