#!/bin/sh

#  Copyright 2008 Michele La Monaca

manifest=$1/manifest.xml
if ! [ -e "$manifest" ]; then exit 0; fi
if ! grep \.pdf "$manifest" > /dev/null; then exit 0; fi

pagenumber=`sed -n "s/.*<pagenumber>\(.*\)<\/pagenumber>.*/\1/p" "$manifest"`
totalpages=`sed -n "s/.*\[.*\/\(.*\)\].*/\1/p" "$manifest"`

if ! [ "$totalpages" -gt 0 ];  then
	totalpages=$(./pdfpagecounter "`ls "$1/"*.pdf`")
	sed -i "s/\[.*\/.*\]/[$pagenumber/$totalpages]/" "$manifest"
else
	sed -i "s/\[.*\/\(.*\)\]/[$pagenumber/\1]/" "$manifest"
fi

sleep 6
