#!/bin/sh
export PATH=$PATH:/tmp
mount -o remount,ro /

reboot_device(){
  for i in `seq 60 -1 1`;do fbink -rpmqh -x1 -y-2 "Rebooting in ${i}s.";sleep 1;done
  reboot
  exit $?
}

trap 'reboot_device' 0 1 2 3 15

IFS=$'\n';export $(ntx_hwconfig -s /dev/mmcblk0|sed -n "/^\[/s,^.[^ ]* ,,;s,',,gp");IFS=$' \t\n'
mountpoint -q "/mnt/onboard" \
  && { tmpfile="/mnt/onboard/iozone.tmp";disk="Internal Memory, $IFlash";} \
  || { fbink -c -f -S4 "no storage found" -m -y2;exit 1;}
mountpoint -q "/mnt/sd" && { tmpfile="/mnt/sd/iozone.tmp";disk="External Memory, $ExternalMem";}

file="${tmpfile%/*}/benchmark-`date +%Y%m%d%H%M%S.txt`"

msg1="One-Click Benchmark v0.1b (c) 2019 BloodRagg"
msg2="(powered by IOzone v3.487)"

echo "$msg1"|tee -a "$file"|fbink -c -f -x0 -y1 >/dev/null 2>&1
echo "$msg2"|tee -a "$file"|fbink -y2 -m >/dev/null 2>&1

[ -n "$tmpfile" ] && {
  echo "Results   : ${file##*/}" |tee -a "$file"| fbink -y4 >/dev/null 2>&1
  echo "Benchmark : $disk" |tee -a "$file"| fbink -y5 >/dev/null 2>&1
  printf "\nPCB: $PCB\n\n" >> "$file"
  fbink -y7 "Running..." >/dev/null 2>&1
  mount -o remount,rw,sync,noatime,nodiratime ${tmpfile%/*}
  iozone -e -I -a -s 1M -r4k -r8k -r16k -r32k -r64k -r128k -r256k -r512k -r1M  -i 0 -i 1 -i 2 -f "$tmpfile" > "$file"
  cat "$file"|grep "^ [0-9 ]*"|cut -c-43|cut -c7-|fbink -F ibm -S3 -y7
  cat "$file"|grep "^ [0-9 ]*"|cut -c43-|cut -c-40|fbink -F ibm -S3 -y20
  [ -f "$tmpfile" ] && rm -f "$tmpfile"
}

