#!/bin/sh

# padlock v0.1c (c) GPLv2 2019 by BloodRagg
# Todo:
# * enable backlight
# * start lock before sleep/screen off

[ -f "$1" ] || exit 1
APP=$1

KEY_HEIGTH=100
MH=$((KEY_HEIGTH/2))
KEY_WIDTH=93
MW=$((KEY_WIDTH/2))

get_input(){
  while :; do
    eval $(\
      head -c $((8*16)) /dev/input/event1|\
      hexdump -ve '8/2 "%d " "\n"'|\
      awk '{if ($6==0 && $7!=0) {print "x="$7}};{if ($6==1) {print "y="$7}}'
    )

    case 1 in
      $((x<=$((820-MH))))  ) continue;;
      $((x<=$((MH+820))))  ) keys="! @ # $ % ^ & * ( )";;
      $((x<=$((MH+926))))  ) keys="1 2 3 4 5 6 7 8 9 0";;
      $((x<=$((MH+1038)))) ) keys="q w e r t y u i o p";;
      $((x<=$((MH+1160)))) ) keys="a s d f g h j k l .";;
      $((x<=$((MH+1270)))) ) keys="z x c v b n m , <- <-";;
      $((x<=$((MH+1386)))) ) keys="- = + ~ ~ ~ [ ] <| <|";;
    esac

    case 1 in
      $((y<=$((52-MW))))   ) continue;;
      $((y<=$((MW+52))))   ) key=`echo "$keys"|awk '{print $10}'`;;
      $((y<=$((MW+160))))  ) key=`echo "$keys"|awk '{print $9}'`;;
      $((y<=$((MW+268))))  ) key=`echo "$keys"|awk '{print $8}'`;;
      $((y<=$((MW+376))))  ) key=`echo "$keys"|awk '{print $7}'`;;
      $((y<=$((MW+484))))  ) key=`echo "$keys"|awk '{print $6}'`;;
      $((y<=$((MW+592))))  ) key=`echo "$keys"|awk '{print $5}'`;;
      $((y<=$((MW+700))))  ) key=`echo "$keys"|awk '{print $4}'`;;
      $((y<=$((MW+808))))  ) key=`echo "$keys"|awk '{print $3}'`;;
      $((y<=$((MW+916))))  ) key=`echo "$keys"|awk '{print $2}'`;;
      $((y<=$((MW+1024)))) ) key=`echo "$keys"|awk '{print $1}'`;;
    esac

    case $key in
      [a-z0-9!@#$%^\&\*\(\)\-\=\+\ \[\]\,\.]) pass="$pass$key";;
      "~") pass="${pass} ";; #space is used as delimiter,swapped with ~
      "<-") pass="${pass%?}";;
      "<|") [ -n "$pass" ] && { printf "$pass"|sha256sum;break;};;
    esac
    fbink -f -S6 -x-1 -y0 " " >/dev/null 2>&1 &
  done
}

set_pw(){
  local try=0
  until [ "$try" -eq 3 ];do
    fbink -c -g file="${0%.*}.png" >/dev/null 2>&1
    fbink -x0 -y2 -S6 "New password:" -m >/dev/null 2>&1
    local p1=`get_input`
    fbink -x0 -y2 -S6 "Retype password:" -m >/dev/null 2>&1
    local p2=`get_input`
    [ -n "$p1" -a "$p1" = "$p2" ] && {
      printf "$p1" > "${0%.*}.pass"
      fbink -x0 -y2 -S6 "Password active!" -m >/dev/null 2>&1
      sleep 2
      break
    } || {
      fbink -x0 -y2 -S6 "Passwords don't match" -m >/dev/null 2>&1
      sleep 2
    }
  done
}

get_pw(){
  local try=0
  until [ "$try" -eq 3 ];do
    fbink -c -g file="${0%.*}.png" >/dev/null 2>&1
    fbink -x0 -y2 -S6 "Enter password:" -m >/dev/null 2>&1
    try=$((try+1))
    [ "`get_input`" = "`cat ${0%.*}.pass`" ] && {
      exec $APP &
      exit 0
    } || {
      fbink -h -x0 -y2 -S8 "Incorrect" -m >/dev/null 2>&1
      sleep 1
    }
  done
  fbink -c -f -x0 -y5 -S8 "Access denied" -m >/dev/null 2>&1
  poweroff
  exit 1
}

[ -f "${0%.*}.pass" ] || set_pw
get_pw
