#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

from __future__ import unicode_literals, division, absolute_import, print_function

import re

from compatibility_utils import PY2

if PY2:
    text_type = unicode
    characterize = unichr
else:
    text_type = str
    characterize = chr

matrix = {'nbsp'  : ('0x00A0', '&#160;'),
          'shy'   : ('0x00AD', '&#173;'),
          'nnbsp' : ('0x202F', '&#8239;'),
          'thinsp': ('0x2009', '&#8201;'),
          'zwj'   : ('0x200D', '&#8205;'),
          'wj'    : ('0x2060', '&#8288;'),
          'zwnbsp': ('0xFEFF', '&#65279;')}


def run(bk):
    # Get preferences from json prefs
    master_prefs = bk.getPrefs()
    # Use defaults if json doesn't yet exist
    if 'matrix' not in master_prefs:
        master_prefs['matrix'] = matrix

    NO_CHANGE = True
    for (id, href) in bk.text_iter():
        html = bk.readfile(id)
        if not isinstance(html, text_type):
            html = text_type(html, 'utf-8')
        html_orig = html

        for key, value in master_prefs['matrix'].items():
            pattern = r'''%s''' % characterize(int(value[0], 16))
            # print (repr(pattern))
            html = re.sub(pattern, value[1], html)
        if not html == html_orig:
            NO_CHANGE = False
            bk.writefile(id, html)
            print('Shady characters found in %s - file altered' % href)
        else:
            print ('No shady characters found in %s.' % href)
    if NO_CHANGE:
            print('No shady characters found at all - no files altered.')

    bk.savePrefs(master_prefs)

    return 0


def main():
    print ('I reached main when I should not have\n')
    return -1
