#!/bin/sh
#cleanup(){ ;}
#trap cleanup 0 1 2 3 13 15

VERSION="v0.1d alpha"
PROGRAM="KOBOeReader Firmware Utility"
LICENSE="GPLv2"

DEBUG=0

MOUNT="/media/$USER/KOBOeReader/"

refresh(){
  echo "Refreshing..."
  MODE_PC="Disconnected"
  MODE_KOBO="Disconnected"
  lsusb|grep -q "Linux-USB Ethernet" && {
    ip link|grep -q enp.[^:]*u;[ $? -eq 0 ] && {
      MODE_PC="Connected USB-Networking (192.168.2.1)"
      MODE_KOBO="Connected USB-Networking (192.168.2.2)"
    }
  }
  lsusb|grep -q "Kobo Inc." && { MODE_PC="Connected";MODE_KOBO="Connected";} && {
    grep KOBOeReader /proc/mounts \
     && MODE_KOBO="Connected USB-Storage (Mounted)" \
     || MODE_KOBO="Connected USB-Storage (Unmounted)"
  }
  [ -f "${0%/*}/rcS" ] && FILE_RCS="Ok" || FILE_RCS="ERROR: run retrieve rcS first!"
}

g(){
  DIR=`mktemp -d`
  FILE="$DIR/etc/init.d/on-animator.sh"
  mkdir -p "$DIR/etc/init.d"

  cat <<\EOF > $FILE.original
#!/bin/sh

PRODUCT=`/bin/sh /bin/kobo_config.sh`;
[ $PRODUCT != trilogy ] && PREFIX=$PRODUCT-

i=0;
while true; do
        i=$((((i + 1)) % 11));
        zcat /etc/images/$PREFIX\on-$i.raw.gz | /usr/local/Kobo/pickel showpic 1;
        usleep 250000;
done 
EOF

  cat <<\EOF > $FILE
#!/bin/sh
cp $0.original $0
PRODUCT=`/bin/sh /bin/kobo_config.sh`;
[ $PRODUCT != trilogy ] && PREFIX=$PRODUCT-

i=0;
while true; do
        i=$((((i + 1)) % 11));
        zcat /etc/images/$PREFIX\on-$i.raw.gz | /usr/local/Kobo/pickel showpic 1;
        usleep 250000;
        mountpoint -q /mnt/onboard && { [ -f /mnt/onboard/rcS ] || cp /etc/init.d/rcS /mnt/onboard/rcS;}
done 
EOF
  chmod +x $FILE $FILE.original
  tar zcf $DIR/KoboRoot.tgz -C $DIR etc --remove-files
  mountpoint -q $MOUNT && {
    cp "$DIR/KoboRoot.tgz" "$MOUNT/.kobo/KoboRoot.tgz"
    sync
    umount $MOUNT
    echo "SUCCESS: disconnect and reconnect KOBOeReader to allow updating."
  } || {
    echo "ERROR: KOBOeReader not mounted!"
  }
}

h(){
  mountpoint -q $MOUNT && {
    [ -f "$MOUNT/rcS" ] && cp "$MOUNT/rcS" "${0%/*}" || rm -f "$MOUNT/rcS"
    sync
    echo "SUCCESS: rcS installed."
  } || {
    echo "ERROR: KOBOeReader not mounted!"
  }
}

t(){
  [ -f "${0%/*}/rcS" ] ||  { echo "ERROR: run retrieve rcS first!";return;}
  mountpoint -q $MOUNT || { echo "ERROR: KOBOeReader not mounted!";return;}

  #extract
  DIR=`mktemp -d`
  mkdir -p "$DIR/etc/init.d"
  cp "${0%/*}/rcS" "$DIR/etc/init.d/rcS"
  cp "${0%/*}/rcS" "$DIR/etc/init.d/rcS.original"
  chmod +x "$DIR/etc/init.d/rcS"
  chmod +x "$DIR/etc/init.d/rcS.original"

  cat <<\EOF>> "$DIR/etc/init.d/rcS"
#added
mv /etc/init.d/rcS.original /etc/init.d/rcS
mkdir -p /dev/pts
mount -t devpts devpts /dev/pts
mount -o rbind /drivers/$PLATFORM/usb/gadget /lib/modules/`uname -r`
/bin/busybox depmod -a
modprobe g_ether
ifconfig usb0 192.168.2.2
cp /etc/inetd.conf /tmp/inetd.conf
echo '23 stream tcp nowait root /bin/busybox telnetd -i' > /tmp/inetd.conf
/usr/sbin/inetd -f /tmp/inetd.conf &
cp /opt/*.log /mnt/onboard
EOF

  #create KoboRoot
  tar zcf $DIR/KoboRoot.tgz -C $DIR etc --remove-files
  sync
  cp $DIR/KoboRoot.tgz $MOUNT/.kobo/KoboRoot.tgz \
    && echo "SUCCESS: disconnect and reconnect KOBOeReader to allow updating."
  sync
  umount $MOUNT
  u
}

u(){
  echo "Waiting for KOBOeREADER network connection ..."
  while :; do
   ip link|grep enp.[^:]*u;[ $? -eq 0 ] && break
   sleep 1;t=$((t+1))
   [ $t -lt 60 ] || break
  done
  CONNECTION=KOBOeReader
  DEVICE=`nmcli device|awk '/enp.[^: ]*u/{print $1}'`
  nmcli device disconnect $DEVICE
  nmcli con show|grep -q KOBOeReader || nmcli con add con-name $CONNECTION ifname $DEVICE type ethernet ip4 192.168.2.1/32 ipv4.method manual ipv4.routes 192.168.2.0/24 ipv6.method ignore
  nmcli connection up "$CONNECTION"
  telnet 192.168.2.2
}

s(){
  [ -f "${0%/*}/rcS" ] ||  { echo "ERROR: run retrieve rcS first!";return;}
  mountpoint -q $MOUNT || { echo "ERROR: KOBOeReader not mounted!";return;}

  #extract
  DIR=`mktemp -d`
  mkdir -p "$DIR/etc/init.d"
  cp "${0%/*}/rcS" "$DIR/etc/init.d/rcS"
  cp "${0%/*}/rcS" "$DIR/etc/init.d/rcS.original"
  chmod +x "$DIR/etc/init.d/rcS"
  chmod +x "$DIR/etc/init.d/rcS.original"
  cat <<\EOF>> "$DIR/etc/init.d/rcS"
#added
mv /etc/init.d/rcS.original /etc/init.d/rcS
mount -o remount,ro /                                         #rootfs
grep /mnt/onboard /proc/mounts && umount -l /mnt/onboard      #KOBOeReader

for i in `find /drivers/$PLATFORM/usb -iname '*.ko'`
  do ln -s $i /lib/modules/`uname -r`
done
busybox depmod -a
modprobe g_ether
ifconfig usb0 192.168.2.2

#kobo countdown
sleep 10
zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
for i in 5 4 3 2 1 0;do
  zcat /etc/images/$PREFIX\on-${i}.raw.gz | /usr/local/Kobo/pickel showpic
  sleep 1
done

#dump disk over usb
DISK=`fdisk -l|awk '{RS=":"}/Disk/{print $2}'`
SIZE=`fdisk -l -u|grep $(blkid|awk -F: '/recoveryfs/{print $1}')|awk '{print $3}'`
[ -e $DISK ] && cat $DISK | busybox nc 192.168.2.1 6000
sync
zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
zcat /etc/images/$PREFIX\reboot.raw.gz | /usr/local/Kobo/pickel showpic
reboot
EOF
  
  [ "$1" = "tiny" ] && sed -i 's/cat $DISK/dd if=$DISK bs=512 count=$SIZE/' "$DIR/etc/init.d/rcS"

  #create KoboRoot
  tar zcf $DIR/KoboRoot.tgz -C $DIR etc --remove-files
  sync
  cp $DIR/KoboRoot.tgz $MOUNT/.kobo/KoboRoot.tgz \
    && echo "SUCCESS: disconnect and reconnect KOBOeReader to allow updating."
  sync
  umount $MOUNT
  r
}

r(){
  echo "Waiting for KOBOeREADER network connection ..."
  while :; do
   ip link|grep enp.[^:]*u;[ $? -eq 0 ] && break
   sleep 1;t=$((t+1))
   [ $t -lt 60 ] || break
  done
  CONNECTION=KOBOeReader
  DEVICE=`nmcli device|awk '/enp.[^: ]*u/{print $1}'`
  nmcli device disconnect $DEVICE
  nmcli con show|grep -q KOBOeReader || nmcli con add con-name $CONNECTION ifname $DEVICE type ethernet ip4 192.168.2.1/32 ipv4.method manual ipv4.routes 192.168.2.0/24 ipv6.method ignore
  nmcli connection up "$CONNECTION"
  time nc -l 6000 |7z a -si backup-`date +%Y%m%d%H%M%S`.img.7z
}

a(){
  SQLDB="/media/$USER/KOBOeReader/.kobo/KoboReader.sqlite"
  VALUES=`sqlite3 $SQLDB "PRAGMA table_info(user);"|wc -l`
  QUERY=`for i in \`seq $VALUES\`;do [ $i -eq 1 ] && printf "INSERT INTO user VALUES (";printf "''";[ $i -ne $VALUES ] && printf "," || printf ");\n";done`
  sqlite3 /media/$USER/KOBOeReader/.kobo/KoboReader.sqlite <<EOF
$QUERY
EOF
  [ $? -eq 0 ] && echo "success: disconnect and reconnect KOBOeReader to allow updating."
  sync
  umount /media/$USER/KOBOeReader
}

readkey(){ while :; do stty raw -echo;key=`dd bs=1 count=1 </dev/tty 2>/dev/null`;stty -raw echo;echo $key;break;done;}

menu(){
  while :; do
  refresh
  clear
  cat <<EOF
$PROGRAM $VERSION (c) $LICENSE feb 2019 by BloodRagg [qXt]
==============================================================================
  PC: $MODE_PC
KOBO: $MODE_KOBO
 rcS: $FILE_RCS
==============================================================================
PC                                                                        KOBO
==============================================================================
h) receive rcS                                                 retrieve rcS (g

u) start telnet session                                enable telnet server (t
r) receive firmware dump                           start full firmware dump (s
                                                   start tiny firmware dump (d

                                                              activate kobo (a
                                                        retrieve boot speed (b
                                                            wipe free space (w
p) refresh menu
q) quit
==============================================================================
EOF
    printf "Choice: "
    key=`readkey`
    printf "$key\n"
    case $key in 
      a|g|h|t|u|s|r) $key;;
      d) s tiny;;
      .) echo "reloading...";$0;;
      p) refresh;;
      q) exit;;
    esac
    [ "$key" = "p" ] || { printf "\nPress any key...";readkey;}
  done
}

menu
