#!/bin/sh
ksmroot=${ksmroot:-"/adds/kbmenu"}
exepath=/adds/syncthing
configpath=.config/syncthing_01
configlog=/mnt/onboard/syncthing_generate_$(date +%Y%m%d_%H%M%S).log


if pkill -0 syncthing ; then
  $ksmroot/kbmessage.sh "There is already an instance of syncthing running!"
fi

if [ ! -f "${exepath}/syncthing" ]; then
  $ksmroot/kbmessage.sh "Cannot find ${exepath}/syncthing"
  exit
fi

ifconfig lo | grep -q addr:127.0.0.1 || ifconfig lo 127.0.0.1

if [ ! -f "${configpath}/config.xml" ]; then
  ecode=0
  $ksmroot/scripts_intern/div/on-animator.sh &
  ${exepath}/syncthing -generate=${configpath} >> ${configlog} 2>&1
  ecode=$?
  killall on-animator.sh
  if [ "${ecode}" != "0" ]; then
    $ksmroot/kbmessage.sh "-f ${configlog}"
    exit
  else
    $ksmroot/kbmessage.sh "Syncthing has been configured successfully"
  fi
fi

(/adds/syncthing/syncthing -no-browser -home="${configpath}" -gui-address=0.0.0.0:8384 >> /dev/null 2>&1 &)

